package com.yeejoin.amos.boot.module.tzs.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
/**
 * 电梯技术参数
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tzs_jg_elevator_tech_info")
@ApiModel(value="TzsJgElevatorTechInfo对象", description="电梯技术参数")
public class TzsJgElevatorTechInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "额定速度")
    private String ratedSpeed;

    @ApiModelProperty(value = "提升高度")
    private String mainLiftingHeight;

    @ApiModelProperty(value = "控制方式")
    private String controlType;

    @ApiModelProperty(value = "层站")
    private String layerStation;

    @ApiModelProperty(value = "额定载重")
    private String ratedLoad;

    @ApiModelProperty(value = "轿厢尺寸")
    private String cabin;

    @ApiModelProperty(value = "驱动主机型号")
    private String driveType;

    @ApiModelProperty(value = "驱动主机编号")
    private String driveCode;

    @ApiModelProperty(value = "驱动主机制造单位")
    private String driveProduceUnit;

    @ApiModelProperty(value = "驱动主机额定功率")
    private String drivePower;

    @ApiModelProperty(value = "驱动主机额定转速")
    private String driveSpeeds;

    @ApiModelProperty(value = "驱动主机减速比")
    private String reductionRatio;

    @ApiModelProperty(value = "控制柜型号")
    private String controlModel;

    @ApiModelProperty(value = "控制柜编号")
    private String controlCode;

    @ApiModelProperty(value = "控制柜制造单位")
    private String controlFacUnit;

    @ApiModelProperty(value = "悬挂系统悬挂介质种类")
    private String susMediumType;

    @ApiModelProperty(value = "悬挂系统悬挂介质型号")
    private String susMediumModel;

    @ApiModelProperty(value = "悬挂系统悬挂介质数量")
    private String susMediumQuantity;

    @ApiModelProperty(value = "悬挂系统悬挂介质规格")
    private String susMediumSpe;

    @ApiModelProperty(value = "限速器型号")
    private String governorModel;

    @ApiModelProperty(value = "限速器编号")
    private String governorNum;

    @ApiModelProperty(value = "限速器制造单位")
    private String governorUnit;

    @ApiModelProperty(value = "限速器检验日期")
    private Date governorInsDate;

    @ApiModelProperty(value = "安全钳型号")
    private String safeGearModel;

    @ApiModelProperty(value = "安全钳编号")
    private String safeGearNum;

    @ApiModelProperty(value = "安全钳制造单位")
    private String safeGearProdUnit;

    @ApiModelProperty(value = "轿厢缓冲器型号")
    private String carBufModel;

    @ApiModelProperty(value = "轿厢缓冲器编号")
    private String carBufNum;

    @ApiModelProperty(value = "轿厢缓冲器制造单位")
    private String carBufProdUnit;

    @ApiModelProperty(value = "对重缓冲器型号")
    private String countBufModel;

    @ApiModelProperty(value = "对重缓冲器编号")
    private String countBufNum;

    @ApiModelProperty(value = "对重缓冲器制造单位")
    private String countBufProdUnit;

    @ApiModelProperty(value = "层门门锁装置型号")
    private String landDoorLockModel;

    @ApiModelProperty(value = "层门门锁装置编号")
    private String landDoorLockNum;

    @ApiModelProperty(value = "层门门锁装置制造单位")
    private String landDoorLockProdUnit;

    @ApiModelProperty(value = "轿门门锁装置型号")
    private String carDoorLockModel;

    @ApiModelProperty(value = "轿门门锁装置编号")
    private String carDoorLockNum;

    @ApiModelProperty(value = "轿门门锁装置制造单位")
    private String carDoorLockProdUnit;

    @ApiModelProperty(value = "上行保护装置型号")
    private String upProtectModel;

    @ApiModelProperty(value = "上行保护装置编号")
    private String upProtectNum;

    @ApiModelProperty(value = "上行保护装置制造单位")
    private String upProtectProdUnit;

    @ApiModelProperty(value = "轿厢意外移动保护装置型号")
    private String carAccProtModel;

    @ApiModelProperty(value = "轿厢意外移动保护装置编号")
    private String carAccProtNum;

    @ApiModelProperty(value = "轿厢意外移动保护装置制造单位")
    private String carAccProtProdUnit;

    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;


}
