package com.yeejoin.amos.boot.module.tzs.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
/**
 * 特种设备基本信息-其他信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tzs_jg_other_info")
@ApiModel(value="TzsJgOtherInfo对象", description="特种设备基本信息-其他信息")
public class TzsJgOtherInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "保险机构")
    private String insuranceOrg;

    @ApiModelProperty(value = "保险到期日")
    private Date expiryDate;

    @ApiModelProperty(value = "物联网机构（非必填）")
    private String iotOrg;

    @ApiModelProperty(value = "物联网接入标志（非必填）")
    private String iotSign;

    @ApiModelProperty(value = "有无监控(有、无)")
    private String isMonitor;

    @ApiModelProperty(value = "96333识别码(七位电梯应急救援识别码)")
    private String code96333;

    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

}
