package com.yeejoin.amos.boot.module.tzs.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
/**
 * 特种设备基本信息-监督管理信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tzs_jg_supervise_info")
@ApiModel(value="TzsJgSuperviseInfo对象", description="特种设备基本信息-监督管理信息")
public class TzsJgSuperviseInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "管辖分局组织机构代码")
    private String orgBranchCode;

    @ApiModelProperty(value = "管辖分局名称")
    private String orgBranchName;

    @ApiModelProperty(value = "是否重点监察设备(是、否)")
    private String keyMonitoringEqu;

    @ApiModelProperty(value = "是否在人口密集区(是、否)")
    private String denselyPopulatedAreas;

    @ApiModelProperty(value = "是否在重要场所(是、否)")
    private String importantPlaces;

    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

}
