package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 气瓶充装信息--充装前检查
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
@TableName("tz_cylinder_filling")
public class CylinderFilling  {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @TableField(value = "rec_date", fill = FieldFill.INSERT_UPDATE)
    protected Date recDate;

    @TableField(value = "rec_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String recUserId;


    /**
     * 充装前检查Id
     */
	@TableField("filling_before_id")
    private String fillingBeforeId;

    /**
     * 充装企业名称
     */
	@TableField("filling_unit_name")
    private String fillingUnitName;

    /**
     * 出厂编号
     */
	@TableField("factory_num")
    private String factoryNum;

    /**
     * 气瓶唯一标识码
     */
	@TableField("sequence_code")
    private String sequenceCode;

    /**
     * 是否在检验有效期以内
     */
	@TableField("is_valid")
    private String isValid;

    /**
     * 警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致
     */
	@TableField("same")
    private Integer same;

    /**
     * 气瓶外表面的颜色标志是否符合规定
     */
	@TableField("is_regulations")
    private Integer isRegulations;

    /**
     * 气瓶瓶阀的出气口螺纹型式是否符合GB/T15383
     */
	@TableField("is_compliance_withGBT")
    private Integer isComplianceWithgbt;

    /**
     * 气瓶内有无剩余压力
     */
	@TableField("have_still_pressure")
    private Integer haveStillPressure;

    /**
     * 气瓶外表面有无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷
     */
	@TableField("is_complete")
    private Integer isComplete;

    /**
     * 气瓶的安全附件齐全并符合安全要求
     */
	@TableField("have_security_documents")
    private Integer haveSecurityDocuments;

    /**
     * 检查人员姓名
     */
	@TableField("inspector_user")
    private String inspectorUser;

    /**
     * 检查时间
     */
	@TableField("inspection_date")
    private String inspectionDate;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 0-新增   1-更新  2-删除
     */
	@TableField("sync_state")
    private Integer syncState;

    /**
     * 对接公司编码
     */
	@TableField("app_id")
    private String appId;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;

}
