package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.JsonValueUtils;
import com.yeejoin.amos.boot.module.tzs.api.mapper.IdxUjerMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.BizRecordCount;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.IdxUjer;
import com.yeejoin.amos.boot.module.tzs.flc.api.feign.IdxFeignService;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.InspectionService;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.*;

@Service
public class InspectionServiceImpl implements InspectionService {

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    IdxFeignService idxFeignService;

    @Autowired
    IdxUjerMapper idxUjerMapper;

    @Autowired
    JdbcTemplate bizJdbcTemplate;

    @Override
    public IPage<IdxUjer> bizDetailList(
            String dimensionTableId,
            String selectValue,
            String bizType, int current, int size
    ) {
        List<String> ids = idxFeignService.getTreeChildIds(dimensionTableId, selectValue).getResult();
        IPage<IdxUjer> idxUjerPage = new Page<>(current, size);
        return idxUjerMapper.getPage(idxUjerPage, ids, bizType);
    }

    @Override
    public List<Map<String, Object>> bizRecordCountByField(List<BizRecordCount> bizRecordCountList) {
        List<Map<String, Object>> result = new ArrayList<>();
        for (BizRecordCount requestData : bizRecordCountList) {
            Map map = JSONObject.parseObject(JSONObject.toJSONString(requestData), Map.class);
            StrSubstitutor ss = new StrSubstitutor(map);

            String selectSql = "SELECT ";
            if (!ValidationUtil.isEmpty(requestData.getBizRecordItems())) {
                requestData.setExpression(buildBizRecordItems(requestData.getBizRecordItems()));
            }

            if (!ValidationUtil.isEmpty(requestData.getExpression())) {
                selectSql += requestData.getExpression() + " as count";
            } else {
                selectSql += "COUNT(*) count";
            }

            if (!ValidationUtil.isEmpty(requestData.getTableName())) {
                selectSql = selectSql + " FROM ${tableName}";
            }

            if (!ValidationUtil.isEmpty(requestData.getFieldKey())) {
                selectSql = selectSql + (selectSql.contains("WHERE") ? " AND" : " WHERE") + " ${fieldKey}='${fieldValue}'";
            }
            selectSql = ss.replace(selectSql);
            Map<String, Object> queryResult = bizJdbcTemplate.queryForMap(selectSql);

            HashMap<String, Object> item = new HashMap<>();
            item.put("key", requestData.getTitle());
            item.put("value", queryResult.get("count"));
            result.add(item);
        }
        return result;
    }

    @Override
    public JSONObject getSafetySupervisionCode(String bizTable) {
        String safetySupervisionCode = "（%s）市监特令中[%s]第  %s 号";
        AgencyUserModel agencyUserModel = Privilege.agencyUserClient.getme().getResult();
        Object reginSeq = JsonValueUtils.getValueByKey(JSONObject.parse(JSON.toJSONString(agencyUserModel)), "companys", "companys.0.regionSeq");
        String region = "";
        if (!ValidationUtil.isEmpty(reginSeq)) {
            List<RegionModel> result = Systemctl.regionClient.queryDeptByIds(reginSeq.toString()).getResult();
            for (int i = 0; i < result.size(); i++) {
                RegionModel regionModel = result.get(i);
                String regionName = regionModel.getRegionName();
                if (regionName.contains("市") || regionName.contains("区") || regionName.contains("县")) {
                    region = region + regionName.substring(0, 1);
                }
            }
        }

        String countSql = "SELECT count(1) FROM " + bizTable;
        Long count = bizJdbcTemplate.queryForObject(countSql, Long.class);
        int year = DateUtils.getYear(DateUtils.getDateNow());

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", String.format(safetySupervisionCode, region, year, count + 1));
        return jsonObject;
    }

    @Override
    public JSONObject getSafetySupervisionInfo() {
        AgencyUserModel agencyUserModel = Privilege.agencyUserClient.getme().getResult();
        Object companyId = JsonValueUtils.getValueByKey(JSONObject.parse(JSON.toJSONString(agencyUserModel)), "companys", "companys.0.sequenceNbr");
        Collection<CompanyModel> result = Privilege.companyClient.queryAgencyTree(null).getResult();

        JSONObject jsonObject = getParentCompanyName(JSONArray.parseArray(JSONArray.toJSONString(result)), companyId);
        if (!ValidationUtil.isEmpty(jsonObject)){
            String parentCompanyName = jsonObject.getString("companyName");
            jsonObject.clear();
            jsonObject.put("reconsiderOrgName", parentCompanyName + "/" + parentCompanyName.substring(0, parentCompanyName.indexOf("区") + 1) + "人民政府");
            jsonObject.put("lawsuitOrgName", parentCompanyName.substring(0, parentCompanyName.indexOf("区") + 1) + "人员法院");
        } else {
            jsonObject = new JSONObject();
            jsonObject.put("reconsiderOrgName", "");
            jsonObject.put("lawsuitOrgName", "");
        }

        return jsonObject;
    }

    private String buildBizRecordItems(List<BizRecordCount.BizRecordItem> bizRecordItems) {
        String sql = "";
        for (BizRecordCount.BizRecordItem item : bizRecordItems) {
            StringJoiner whereSql = new StringJoiner(" OR ");
            for (int i = 1; i <= item.getColumnIndex(); i++) {
                whereSql.add(String.format("%s%s='%s'", item.getColumnPrefix(), i, item.getColumnValue()));
            }
            sql = ValidationUtil.isEmpty(sql) ? "" : "+" + String.format("(SELECT count(*) FROM %s WHERE %s)", item.getTableName(), whereSql);
        }
        return sql;
    }

    private static JSONObject getParentCompanyName(JSONArray companyModels, Object companyId) {
        for (int i = 0; i < companyModels.size(); i++) {
            JSONObject jsonObject = findCompanyById(companyModels.getJSONObject(i), companyId);
            if (!ValidationUtil.isEmpty(jsonObject)) {
                return findCompanyById(companyModels.getJSONObject(i), jsonObject.getString("parentId"));
            }
        }
        return null;
    }

    private static JSONObject findCompanyById(JSONObject treeNode, Object companyId) {
        if (treeNode.getString("sequenceNbr").equals(companyId)) {
            return treeNode;
        } else {
            JSONArray children = treeNode.getJSONArray("children");
            if (!ValidationUtil.isEmpty(children)) {
                for (int i = 0; i < children.size(); i++) {
                    JSONObject result = findCompanyById(children.getJSONObject(i), companyId);
                    if (!ValidationUtil.isEmpty(result)) {
                        return result;
                    }
                }
            }
            return null;
        }
    }
}
