package com.yeejoin.amos.knowledgebase.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.foundation.utils.TreeNode;

import java.util.Collection;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/1/18 11:36
 */
@EqualsAndHashCode
@Data
public class MultipleNodeModel implements TreeNode<MultipleNodeModel, Long> {

    private String nodeType;

    private Long nodeKey;

    private String nodeTitle;

    private Long nodeParent;

    private Collection<MultipleNodeModel> nodeChildren;

    private Object nodeExtraInfo;

    @Override
    public Long getMyParentId() {
        return this.nodeParent;
    }

    @Override
    public Long getMyId() {
        return this.nodeKey;
    }

    @Override
    public Collection<MultipleNodeModel> getChildren() {
        return this.nodeChildren;
    }

    @Override
    public void setChildren(Collection<MultipleNodeModel> collection) {
        this.setNodeChildren(collection);
    }

    @Override
    public int compareTo(MultipleNodeModel o) {
        return this.getNodeKey().compareTo(o.getNodeKey());
    }

}

