package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.Util.FileUtil;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDeviceDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDeviceImport;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPvDevice;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.HouseholdPvDeviceMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvDeviceService;

/**
 * 户用光伏设备表服务实现类
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Service
public class HouseholdPvDeviceServiceImpl
		extends BaseService<HouseholdPvDeviceDto, HouseholdPvDevice, HouseholdPvDeviceMapper>
		implements IHouseholdPvDeviceService {
	/**
	 * 分页查询
	 */
	public Page<HouseholdPvDeviceDto> queryForHouseholdPvDevicePage(Page<HouseholdPvDeviceDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<HouseholdPvDeviceDto> queryForHouseholdPvDeviceList() {
		return this.queryForList("", false);
	}

	@Override
	public void exportTemplates(HttpServletResponse response) {
		FileUtil.downloadResource("户用光伏-设备导入模板.xlsx", "templates/户用光伏-设备导入模板.xlsx", response);
	}

	@Override
	public void importData(List<HouseholdPvDeviceImport> list, long householdPvId) {
		List<HouseholdPvDevice> dataList = new ArrayList<>();
		for (HouseholdPvDeviceImport householdPvDeviceImport : list) {
			HouseholdPvDevice householdPvDevice = new HouseholdPvDevice();
			BeanUtils.copyProperties(householdPvDeviceImport, householdPvDevice);
			householdPvDevice.setHouseholdPvId(householdPvId);
			dataList.add(householdPvDevice);
		}
		this.baseMapper.insertAndUpdate(dataList);
	}
}