package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.text.ParseException;
import java.util.*;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.module.jxiop.api.dto.*;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.LocalDateTime;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPv;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPvContact;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPvInstall;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPvLease;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.HouseholdPvMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvContactService;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvInstallService;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvLeaseService;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvService;

/**
 * 户用光伏表服务实现类
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Service
public class HouseholdPvServiceImpl extends BaseService<HouseholdPvDto, HouseholdPv, HouseholdPvMapper>
		implements IHouseholdPvService {

	@Autowired
	HouseholdPvMapper householdPvMapper;

	@Autowired
	IHouseholdPvContactService iHouseholdPvContactService;

	@Autowired
	IHouseholdPvLeaseService iHouseholdPvLeaseService;

	@Autowired
	IHouseholdPvInstallService iHouseholdPvInstallService;

	/**
	 * 分页查询
	 */
	public IPage<HouseholdPv> queryForHouseholdPvPage(Page<HouseholdPv> page, HouseholdPvDto dto) {
		LambdaQueryWrapper<HouseholdPv> lambda = new QueryWrapper<HouseholdPv>().lambda();
		lambda.eq(HouseholdPv::getIsDelete, false);
		if (!ObjectUtils.isEmpty(dto.getName())) {
			lambda.like(HouseholdPv::getName, dto.getName());
		}
		if (!ObjectUtils.isEmpty(dto.getPlatformCompanyId())) {
			lambda.eq(HouseholdPv::getPlatformCompanyId, dto.getPlatformCompanyId());
		}
		if (!ObjectUtils.isEmpty(dto.getAddress())) {
			lambda.like(HouseholdPv::getAddress, dto.getAddress());
		}
		if (!ObjectUtils.isEmpty(dto.getNumber())) {
			lambda.like(HouseholdPv::getNumber, dto.getNumber());
		}
		return householdPvMapper.selectPage(page, lambda);
	}

	/**
	 * 列表查询 示例
	 */
	public List<HouseholdPvDto> queryForHouseholdPvList() {
		return this.queryForList("", false);
	}

	@Override
	public void importData(List<HouseholdPvImport> list) {
		ArrayList<HouseholdPv> householdPvs = new ArrayList<>();
		list.forEach(item -> {
			HouseholdPv householdPv = new HouseholdPv();
			householdPv.setCreateTime(LocalDateTime.now().toDate());
			if (!ObjectUtils.isEmpty(item.getExpiryTime())) {
				try {
					Date date = DateUtils.dateParse(item.getExpiryTime(), DateUtils.DATE_PATTERN);
					householdPv.setExpiryTime(date);
				} catch (ParseException e) {
					e.printStackTrace();
				}
			}
			BeanUtils.copyProperties(item, householdPv);
			householdPvs.add(householdPv);
		});
		this.saveBatch(householdPvs);
	}

	@Override
	public List<HouseholdPvExport> selectExportList(HouseholdPvDto dto) {
		List<HouseholdPvExport> householdPvExports = householdPvMapper.selectExportList(dto);
		householdPvExports.forEach(item -> {
			if (!ObjectUtils.isEmpty(item.getPeriod())) {
				JSONArray objects = JSON.parseArray(item.getPeriod());
				if (!ObjectUtils.isEmpty(objects) && objects.size() >= 2) {
					item.setPeriod(objects.get(0) + "-" + objects.get(1));
				}
			}
			List<HouseholdPvDeviceDto> equipList = householdPvMapper.selectEquipList(item.getId());
			if (!ObjectUtils.isEmpty(equipList)) {
				StringBuilder stringBuilder = equipMessage(equipList);
				item.setEquipmentMessage(stringBuilder.toString());
			}
		});
		return householdPvExports;

	}

	private StringBuilder equipMessage(List<HouseholdPvDeviceDto> list) {
		StringBuilder stringBuilder = new StringBuilder();
		list.forEach(item -> {
			stringBuilder.append("类型:").append(ObjectUtils.isEmpty(item.getType()) ? "" : item.getType());
			stringBuilder.append(" 名称:").append(ObjectUtils.isEmpty(item.getName()) ? "" : item.getName());
			stringBuilder.append(" 品牌:").append(ObjectUtils.isEmpty(item.getBrand()) ? "" : item.getBrand());
			stringBuilder.append(" SN编码:").append(ObjectUtils.isEmpty(item.getSNCode()) ? "" : item.getSNCode());
			if (!ObjectUtils.isEmpty(item.getType()) && item.getType().equals("逆变器")) {
				stringBuilder.append(" 序列号:").append(ObjectUtils.isEmpty(item.getSerialNumber()) ? "" : item.getSerialNumber());
				stringBuilder.append(" 功率:").append(ObjectUtils.isEmpty(item.getPower()) ? "" : item.getPower());
			}
			if (!ObjectUtils.isEmpty(item.getType()) && item.getType().equals("其他")) {
				stringBuilder.append(" 描述:").append(ObjectUtils.isEmpty(item.getDescription()) ? "" : item.getDescription());
			}
			stringBuilder.append("\r\n");

		});
		return stringBuilder;
	}

	@Override
	public void deleteBatch(List<Long> ids) {
		householdPvMapper.deleteBatchIds(ids);
	}

	@Override
	public HouseholdPvDto save(HouseholdPvDto householdPvDto) {
		HouseholdPv householdPv = new HouseholdPv();
		BeanUtils.copyProperties(householdPvDto, householdPv);
		this.save(householdPv);

		HouseholdPvContact householdPvContact = new HouseholdPvContact();
		BeanUtils.copyProperties(householdPvDto.getContactInfo(), householdPvContact);
		householdPvContact.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvContactService.save(householdPvContact);

		HouseholdPvLease householdPvLease = new HouseholdPvLease();
		BeanUtils.copyProperties(householdPvDto.getLeaseInfo(), householdPvLease);
		householdPvContact.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvLeaseService.save(householdPvLease);

		HouseholdPvInstall householdPvInstall = new HouseholdPvInstall();
		BeanUtils.copyProperties(householdPvDto.getInstallInfo(), householdPvInstall);
		householdPvInstall.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvInstallService.save(householdPvInstall);

		return householdPvDto;
	}

	@Override
	public HouseholdPvDto update(HouseholdPvDto householdPvDto) {
		HouseholdPv householdPv = new HouseholdPv();
		BeanUtils.copyProperties(householdPvDto, householdPv);
		this.updateById(householdPv);

		HouseholdPvContact householdPvContact = new HouseholdPvContact();
		BeanUtils.copyProperties(householdPvDto.getContactInfo(), householdPvContact);
		iHouseholdPvContactService.update(householdPvContact,new LambdaQueryWrapper<HouseholdPvContact>()
				.eq(HouseholdPvContact::getHouseholdPvId, householdPvDto.getSequenceNbr()));

		HouseholdPvLease householdPvLease = new HouseholdPvLease();
		BeanUtils.copyProperties(householdPvDto.getLeaseInfo(), householdPvLease);
		iHouseholdPvLeaseService.update(householdPvLease,new LambdaQueryWrapper<HouseholdPvLease>()
				.eq(HouseholdPvLease::getHouseholdPvId, householdPvDto.getSequenceNbr()));

		HouseholdPvInstall householdPvInstall = new HouseholdPvInstall();
		BeanUtils.copyProperties(householdPvDto.getInstallInfo(), householdPvInstall);
		iHouseholdPvInstallService.update(householdPvInstall,new LambdaQueryWrapper<HouseholdPvInstall>()
				.eq(HouseholdPvInstall::getHouseholdPvId, householdPvDto.getSequenceNbr()));

		return householdPvDto;
	}

	@Override
	public HouseholdPvDto getBySeq(Long id) {
		HouseholdPv householdPv = this.getById(id);
		HouseholdPvDto householdPvDto = new HouseholdPvDto();
		BeanUtils.copyProperties(householdPv, householdPvDto);

		HouseholdPvContact householdPvContact = iHouseholdPvContactService
				.getOne(new LambdaQueryWrapper<HouseholdPvContact>().eq(HouseholdPvContact::getHouseholdPvId, id));
		if (householdPvContact != null) {
			HouseholdPvContactDto householdPvContactDto = new HouseholdPvContactDto();
			BeanUtils.copyProperties(householdPvContact, householdPvContactDto);
			householdPvDto.setContactInfo(householdPvContactDto);
		}

		HouseholdPvLease householdPvLease = iHouseholdPvLeaseService
				.getOne(new LambdaQueryWrapper<HouseholdPvLease>().eq(HouseholdPvLease::getHouseholdPvId, id));
		if (householdPvLease != null) {
			HouseholdPvLeaseDto householdPvLeaseDto = new HouseholdPvLeaseDto();
			BeanUtils.copyProperties(householdPvLease, householdPvLeaseDto);
			householdPvDto.setLeaseInfo(householdPvLeaseDto);
		}

		HouseholdPvInstall householdPvInstall = iHouseholdPvInstallService
				.getOne(new LambdaQueryWrapper<HouseholdPvInstall>().eq(HouseholdPvInstall::getHouseholdPvId, id));
		if (householdPvInstall != null) {
			HouseholdPvInstallDto householdPvInstallDto = new HouseholdPvInstallDto();
			BeanUtils.copyProperties(householdPvInstall, householdPvInstallDto);
			householdPvDto.setInstallInfo(householdPvInstallDto);

		}

		return householdPvDto;
	}
}