package com.yeejoin.precontrol.controller;

import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.TaskWork;
import com.yeejoin.precontrol.common.service.ITaskWorkService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import com.yeejoin.precontrol.common.vo.TaskWorkVo;
import com.yeejoin.precontrol.controller.publics.BaseController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 
 *
 * @author duanwei
 * @date 2022-07-07
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/task-work", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TaskWorkController extends BaseController { 

	@Autowired
	ITaskWorkService iTaskWorkService;

	/**
	 * 新增
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public boolean saveTaskWork(HttpServletRequest request, @RequestBody TaskWorkVo taskWorkVo) {
		return iTaskWorkService.save(taskWorkVo);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iTaskWorkService.removeById(id);
	}

	/**
	 * 修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
	public boolean updateByIdTaskWork(HttpServletRequest request, @RequestBody TaskWork taskWork) {
		return iTaskWorkService.updateById(taskWork);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public TaskWorkVo selectById(HttpServletRequest request, @PathVariable Long id) {
		return iTaskWorkService.getDetailById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<TaskWork> listPage(String pageNum, String pageSize, TaskWork taskWork) {

		Page<TaskWork> pageBean;
		QueryWrapper<TaskWork> taskWorkQueryWrapper = new QueryWrapper<>();
		Class<? extends TaskWork> aClass = taskWork.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(taskWork);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(taskWork);
						taskWorkQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(taskWork);
						taskWorkQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(taskWork);
						taskWorkQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(taskWork);
						taskWorkQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<TaskWork> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iTaskWorkService.page(pageBean, taskWorkQueryWrapper);
		return page;
	}
	
	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/page", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<TaskWorkVo> listPage(StudioPageableDto pageable, TaskWorkVo taskWorkVo) {
		Person person = getPerson();
		taskWorkVo.setCreatePersonId(person.getId());
		return  iTaskWorkService.page(pageable, taskWorkVo);
	}
}
