package com.yeejoin.amos.boot.module.ugp.biz.controller;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticePageDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.PercentOfPassDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import com.yeejoin.amos.boot.module.ugp.api.service.IInstallationQualityService;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.InstallationQualityImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.WeldServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

import javax.annotation.Resource;
import java.util.List;

/**
 * 质量问题闭环管理-安装质量监检信息-质量监检信息
 *
 * @author system_generator
 * @date 2022-10-09
 */


@RestController
@Api(tags = "质量问题闭环管理-安装质量监检信息-质量监检信息Api")
@RequestMapping(value = "/install-quality")
public class InstallationQualityController extends BaseController {

@Resource
private InstallationQualityImpl services;
@Resource
private WeldServiceImpl weld;

   //查看质量监检信息
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/find")
    @ApiOperation(httpMethod = "GET", value = "质量问题闭环管理-安装质量监检信息-质量监检信息", notes = "质量问题闭环管理-安装质量监检信息-质量监检信息")
    public ResponseModel<Page<PercentOfPassDto>> find(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, PercentOfPassDto percentOfPassDto) {
        return ResponseHelper.buildResponse(services.find(current,size,percentOfPassDto));
    }


    //通过projectId查询焊口信息

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/selectByProjectId/{projectId}")
    @ApiOperation(httpMethod = "get", value = "焊口信息", notes = "焊口信息")
    public ResponseModel<List<WeldDto>> selectByProjectId(@PathVariable("projectId") Long projectId) {
        if (projectId == null) {
            return null;
        }

        return ResponseHelper.buildResponse(weld.getProjectId (projectId));
    }








}
