package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 电梯
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_elevator")
public class SpecialElevator extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 设备全省唯一编号
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 运行速度（m/s）
	 */
	@TableField("running_speed")
	private String runningSpeed;
	/**
	 * 额定载荷（kg）
	 */
	@TableField("rated_load")
	private String ratedLoad;
	/**
	 * 电梯层站（层）
	 */
	@TableField("elevator_landing")
	private String elevatorLanding;
	/**
	 * 提升高度（m）
	 */
	@TableField("lifting_height")
	private String liftingHeight;
	/**
	 * 曳引机型号
	 */
	@TableField("traction_machine_model")
	private String tractionMachineModel;
	/**
	 * 曳引机出厂编号
	 */
	@TableField("traction_machine_factory_num")
	private String tractionMachineFactoryNum;
	/**
	 * 电动机型号
	 */
	@TableField("motor_model")
	private String motorModel;
	/**
	 * 电动机出厂编号
	 */
	@TableField("motor_factory_num")
	private String motorFactoryNum;
	/**
	 * 控制屏型号
	 */
	@TableField("control_panel_model")
	private String controlPanelModel;
	/**
	 * 控制屏出厂编号
	 */
	@TableField("control_panel_factory_num")
	private String controlPanelFactoryNum;
	/**
	 * 限速器型号
	 */
	@TableField("speed_governor_model")
	private String speedGovernorModel;
	/**
	 * 限速器出厂编号
	 */
	@TableField("speed_governor_factory_num")
	private String speedGovernorFactoryNum;
	/**
	 * 控制方式
	 */
	@TableField("control_mode")
	private String controlMode;
	/**
	 * 使用区域长度(m)
	 */
	@TableField("use_area_length")
	private String useAreaLength;
	/**
	 * 输送能力(人/h)
	 */
	@TableField("conveying_capacity")
	private String conveyingCapacity;
	/**
	 * 扶梯倾斜角（°）
	 */
	@TableField("escalator_inclination_angle")
	private String escalatorInclinationAngle;
	/**
	 * 梯级宽度（m）
	 */
	@TableField("step_width")
	private String stepWidth;

}
