package com.yeejoin.precontrol.common.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.PersonAccount;
import com.yeejoin.precontrol.common.entity.UserRegistration;
import com.yeejoin.precontrol.common.entity.platform.PlatformRole;
import com.yeejoin.precontrol.common.param.PersonParam;
import com.yeejoin.precontrol.common.param.PersonStatisticParam;
import com.yeejoin.precontrol.common.param.VerityPersonParam;
import com.yeejoin.precontrol.common.vo.*;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 人员基本信息 服务类
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface IPersonService extends IService<Person> {
	/**
	 * 人员信息查询分页
	 * 
	 * @param personParam
	 * @param pageable
	 * @return
	 */
	Page pageInfo(PersonParam personParam, CommonPageableDto pageable);

	/**
	 * 根据身份证查询人员
	 * 
	 * @param idNumber
	 * @return
	 */
	Person queryByIdNumber(String idNumber);

	/**
	 * 离职
	 *
	 * @param id
	 */
	void departureByPersonId(Long id);

	/**
	 * excel查询
	 * 
	 * @param param
	 * @return
	 */
	List<PersonExcelVo> exportExcel(PersonParam param);

	/**
	 * excel导入
	 *
	 * @param list
	 */
	void importExcel(List<PersonExcelVo> list);

	/**
	 * 名族下拉
	 *
	 * @return
	 */
	List<HashMap<Long, String>> nationSelect();

	/**
	 * 根据账户查询人员
	 * 
	 * @param accountNum
	 * @return
	 */
	PersonVo getPersonVoByAccountNumber(String accountNum);

	/**
	 * 查询人员二维码
	 * 
	 * @param personId
	 * @return
	 */
	JSONObject getQrCodeColorByPersonId(Long personId);

	/**
	 * 人员统计 废弃
	 * 
	 * @return
	 */
	HashMap<String, Object> statistical();

	/**
	 * 红绿码统计
	 * 
	 * @param projectId
	 * @return
	 */
	Map<String, Object> personSituational(Long projectId, Long companyId, String orgCode);

	/**
	 * 人员数量统计
	 * 
	 * @param personStatisticParam
	 * @param pageable
	 * @return
	 */
	IPage<PersonStatisticVo> statisticPageInfo(PersonStatisticParam personStatisticParam, CommonPageableDto pageable);

	/**
	 * 查询已绑定用户account_number
	 * 
	 * @return
	 */
	List<String> selectBindUserSeqs();

	/**
	 * 人员数量根据项目统计
	 *
	 * @param projectId
	 * @return
	 */
	HashMap<String, Object> personByProjectId(Long projectId);

	/**
	 * 同步平台消息的用户信息
	 *
	 * @param jsonObject
	 */
	void syncPerson(JSONObject jsonObject);

	/**
	 * 更新图片为null
	 *
	 * @param person
	 */
	void updatePhoto(Person person);

	/**
	 * 根据项目部判断是否可以加入当前项目
	 * 
	 * @param personId
	 * @return
	 */
	boolean canJoinProject(Long personId, Long projectId);

	/**
	 * 根据项目部判断是否可以加入当前项目
	 * 
	 * @param personId
	 * @return
	 */
	IPage<PersonVo> period(CommonPageableDto pageable, PersonParam personParam, Date start, Date end);

	/**
	 * 同步平台消息的用户信息 公共
	 *
	 * @param jsonObject
	 */
	void syncCommonPerson(JSONObject jsonObject);

	/**
	 * 红码人员
	 * 
	 * @param companyId
	 * @return
	 */
	IPage<PersonVo> redPerson(CommonPageableDto pageable, Long companyId);

	/**
	 * 按照审核状态查询
	 * 
	 * @param pageSize   分页大小
	 * @param pageNumber 页码
	 * @param name       查询名称
	 * @param companyId  公司id
	 * @param projectId  项目id
	 * @return Page<Map>
	 */
	Page<ApprovalPersonVo> verityPageList(int pageSize, int pageNumber, String name, Long companyId, Long projectId, Person person);

	/**
	 * 人员审核
	 * 
	 * @param param VerityPersonParam.class
	 * @return boolean
	 */
	boolean verityPersonInfo(VerityPersonParam param, Person verifyPerson);

	/**
	 * 查询所有安全员
	 *
	 * @return
	 */
	List<Person> listAllSecurityPerson(Long projectId);
	/**
	 * 查询所有技术员
	 *
	 * @return
	 */
	List<Person> listAllTechnicianPerson(Long projectId);

	/**
	 * 更新平台用户
	 *
	 * @param
	 * @return 
	 */
	AgencyUserModel updatePlatformUser(UserRegistration userRegistration);

	/**
	 * 三级安全考试发题
	 *
	 * @param userRegistration
	 * @return 
	 */
	Long passOutThreeLevelExam(UserRegistration userRegistration);
	/**
	 * @Description 檢查人員信息是否完成
	 * @param id
	 * @Return Boolean
	 * @Date 2021/4/8 15:08
	 */
	Boolean checkPersonMessageIsFinish(Long id);

	IPage<PersonStatisticVo> statisticInPersonlistPage(PersonStatisticParam personStatisticParam, CommonPageableDto pageable);
	/**
	 * @Author songLei
	 * @Version  1.0
	 * @Description // 积分系统提供 人员信息
	 * @param userId
	 * @Return PersonMsgVo
	 * @Date 2021/6/22 16:10
	 */
	PersonMsgVo personMsg(Long userId);
	/**
	 * @Author songLei
	 * @Version  1.0
	 * @Description 用户树
	 * @param userId
	 * @Return Object
	 * @Date 2021/6/22 16:10
	 */
	Object personTree(String userId);
	
	
	Boolean savePersonNew(PersonAccount personAccount);
	
	
	 void setRoleName(Person person, String roles);
	 
	 void setNewRoleName(Person person, List<PlatformRole> roles);
	 
	 void inOccupation(PersonAccount personAccount);
	 
	 Boolean updateDept(PersonAccount personAccount);
}
