package com.yeejoin.amos.supervision.common.enums;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author DELL
 *
 */
public enum TaskCheckTypeEnum {
    /**
     * 维保任务排序
     */
    RCJC("日常检查", "1"),
    ZXJC("专项检查", "2");

    /**
     * 名字
     */
    private String name;
    /**
     * 编号
     */
    private String code;

    TaskCheckTypeEnum(String name, String code) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(TaskCheckTypeEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put(e.getCode(), e.getName());
            return map;
        }).collect(Collectors.toList());
    }

    public static TaskCheckTypeEnum getEumByCode(String code) throws Exception {
        Optional<TaskCheckTypeEnum> op = Arrays.stream(TaskCheckTypeEnum.values()).filter(e->e.getCode().equals(code)).findFirst();
        return op.orElseThrow(()->new Exception("非法的条件"));
    }

}
