package com.yeejoin.amos.patrol.business.feign;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.LinkedHashMap;

//装备
@FeignClient(name ="${equip.fegin.name}", configuration = FeignConfiguration.class)
public interface EquipFeign {
    @RequestMapping(value = "${equip.fegin.prefix}"+"/equipSpecific/getSourceNameByEquipSpeId", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getEquipDetail(@RequestParam(value = "id", required = true) Long id);

    @RequestMapping(value = "${equip.fegin.prefix}"+"/equipSpecific/getSourceNameList", method = RequestMethod.POST ,consumes="application/json")
    LinkedHashMap<String,Object> getEquipList(@RequestBody Long id);

    @RequestMapping(value = "${equip.fegin.prefix}"+"/building/myTreeList", method = RequestMethod.GET ,consumes="application/json")
    FeignClientResult myTreeList();


    @RequestMapping(value = "${equip.fegin.prefix}"+"/warehouse-structure/listAll", method = RequestMethod.GET ,consumes="application/json")
    String getStructureNameAll();

    /**
     * 消防建筑树
     * @return
     */
    @RequestMapping(value = "${equip.fegin.prefix}"+"/building/tree", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getBuildingTree();

    @RequestMapping(value = "${equip.fegin.prefix}"+"/building/getBuildingAbsolutePosition", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getBuildingAbsolutePosition();
    /**
     *  所属局域树
     * @return
     */
    @RequestMapping(value = "${equip.fegin.prefix}"+"/area/treeToPartol", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getRegionTress();


    @RequestMapping(value = "${equip.fegin.prefix}"+"/warehouse-structure/gettree/{id}", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> gettreeWarehouse(@PathVariable Long id, @RequestParam(value = "bizOrgCode", required = true) String bizOrgCode, @RequestParam(value = "buildingId", required = false) String buildingId);


    @RequestMapping(value = "${equip.fegin.prefix}"+"/building/getOne", method = RequestMethod.GET ,consumes="application/json")
    FeignClientResult    getBuildingTreeOne(@RequestParam(value = "instanceId", required = true) String instanceId);

}

