package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 特种设备基本信息-制造信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_produce_info")
@ApiModel(value="TmJgProduceInfo对象", description="特种设备基本信息-制造信息")
public class ProduceInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备唯一标识码")

    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "制造单位统一社会信用代码")
    private String produceUnitCreditCode;

    @ApiModelProperty(value = "制造单位名称")
    private String produceUnitName;

    @ApiModelProperty(value = "制造许可编号")
    private String produceLicenseNum;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "制造日期")
    private Date produceDate;

    @ApiModelProperty(value = "是否进口(是、否)")
    private String imported;

    @ApiModelProperty(value = "制造国")
    private String produceCountry;

    @ApiModelProperty(value = "监督检验ID")
    private String inspectionId;

    @ApiModelProperty(value = "型式试验ID")
    private String typeTestId;
}
