package com.yeejoin.amos.api.openapi.face.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.OpenapiFilesModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialInspectModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.SpecialInspectMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.SpecialInspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 检验信息 服务类
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@Component
public class SpecialInspectService
                extends BaseService<SpecialInspectModel, SpecialInspect, SpecialInspectMapper> {

        /**
         * 分页查询
         */
        public Page<SpecialInspectModel> queryForTmSpecialInspectPage(Page page, String agencyCode) {
                return this.queryForPage(page, null, false, agencyCode);
        }

        /**
         * 列表查询 示例
         */
        public List<SpecialInspectModel> queryForTmSpecialInspectList(String agencyCode) {
                return this.queryForList("", false, agencyCode);
        }

		public String createSpecialInspect(List<SpecialInspectModel> model) {
			// TODO Auto-generated method stub
			if (ValidationUtil.isEmpty(model))
				throw new BadRequest("检验信息数据为空.");
	    	
			for (SpecialInspectModel specialInspectModel : model) {
				specialInspectModel.setRecDate(new Date());
				specialInspectModel.setAppId(getAppId());
				SpecialInspectModel  inspectObj =this.createWithModel(specialInspectModel);
				Long sequenceNbr = inspectObj.getSequenceNbr();
				List<OpenapiFilesModel> inspectReportList = specialInspectModel.getInspectReport();
				for (OpenapiFilesModel openapiFilesModel : inspectReportList) {
					openapiFilesModel.setRecDate(new Date());
					openapiFilesModel.setAppId(getAppId());
					openapiFilesModel.setBizId(sequenceNbr);
					openapiFilesModel.setBizName("tm_special_inspect");
					openapiFilesService.createWithModel(openapiFilesModel);
				}
			}
			return "OK";
		}
		private String getAppId() {
			String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
	    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
	    	return bizTokenModel.getAppId();
		}
	    @Autowired
	    private RedisTemplate redisTemplate;
	    @Autowired
	    private OpenapiFilesService openapiFilesService;
}
