package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PointCheckTypeEnum {
	WGJC("外观检查", "WGJC"),
	GNCS("功能测试", "GNCS"),
	HJJC("环境检查", "HJJC"),
	QT("其他", "QT");

	private String name;

	private String value;

	private PointCheckTypeEnum(String name, String value) {
		this.name = name;
		this.value = value;
	}
	

	public static String getName(String value) {
		for (PointCheckTypeEnum c : PointCheckTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getValue(String name) {
		for (PointCheckTypeEnum c : PointCheckTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return null;
	}



	public static PointCheckTypeEnum getEnum(String name) {
		for (PointCheckTypeEnum c : PointCheckTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PointCheckTypeEnum c: PointCheckTypeEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}
	


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public String getValue() {
		return value;
	}


	public void setValue(String value) {
		this.value = value;
	}
}
