package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentManageEntity;
import com.yeejoin.equipmanage.common.vo.EquipmentManageVo;
import com.yeejoin.equipmanage.common.vo.FileUploadVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 服务类
 *
 * @author zjw
 * @date 2020-09-04
 */
public interface EquipmentManageService extends IService<EquipmentManageEntity> {
    /**
     * 系统列表
     * @param equimentName
     * @param equimentCode
     * @param construction
     * @param maintenance
     * @param spage
     * @param pageSize
     * @return
     */
    Map<String, Object> queryEquipmenInfoAndCount(String equimentName, String equimentCode, String construction, String maintenance, String bizOrgCode, String formGroupId , int spage, int pageSize, String controBoxBuildId,String companyId, String nameOrCode);

    /**
     * 获取下拉菜单数据
     * @return
     */
    Map<String, Object> getUtils(String  orgCode);

    /**
     * 获取人员
     * @return
     */
    Map<String, Object> getUsers();

    List<EquipmentManageVo> getSystemList();

    Map<String, Object> deleteById(List<EquipmentManageVo> list);

    /**
     * 生成不重复编码
     * @param param
     * @return
     */
    String checkCode(String param);

    /**
     * 添加
     * @param vo
     * @return
     */
    Map<String, Object> addEquipment(EquipmentManageVo vo);

    /**
     * 获取文件
     * @param id
     * @return
     */
    Map<String, Object> getFiles(String id);

    Map<String, Object> updateEquipment(EquipmentManageVo vo);

    /**
     * 下载附件
     * @param vo
     * @param response
     */
   void  downLoad(FileUploadVo vo, HttpServletResponse response) ;

    /**
     * 校验系统名称重复
     * @param vo
     * @return
     */
    Map<String,Object> chekcName( EquipmentManageVo vo);

}
