package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.CarProperty;
import com.yeejoin.equipmanage.common.entity.vo.CarIndexVo;
import com.yeejoin.equipmanage.common.entity.vo.CarPropertyVo;

import java.util.List;
import java.util.Map;

/**
 *  服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface ICarPropertyService extends IService<CarProperty> {

    /**
     * 根据 iot caod 获取车辆性能指标
     * @param iotCode
     * @return
     */
    List<CarProperty> getCarPropListByIotCode(String iotCode);

    List<CarPropertyVo> getCarPropertyList(CarIndexVo carIndexVo);

    List<CarPropertyVo> getCarPropertyListByCarIds(List<Long> carIds);

    Map<String, Object>  getCarPropertyByCarIds(List<Long> carIds);


}
