package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.dto.EquipmentAlarmLogDto;

import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: IEquipmentSpecificAlarmLogService
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/8/19 10:36
 */
public interface IEquipmentSpecificAlarmLogService extends IService<EquipmentSpecificAlarmLog> {

    /**
     * 修改记录表中confirmType，数据变更未已处理
     */
    void updateAlarmLogByIotCodeAndIndexKey(EquipmentSpecificAlarm equipmentSpecificAlarm);

    /**
     * 通过告警ID，获取告警Log数据
     *
     * @param equipmentSpecificAlarmId
     * @param isConfirm                '' 为全部数据 0 为未确认 1为已确认
     * @return
     */
    List<EquipmentSpecificAlarmLog> getIsConfirmByAlarmId(Long equipmentSpecificId, String equipmentSpecificIndexKey, String isConfirm);

    /**
     * 获取设备告警环比
     *
     * @return
     */
    Map<String, Object> equipAlarmLink(String date);

    /**
     * 获取告警Log未消除信息集合
     * @param equipmentCode
     * @param nameKey
     * @param value
     * @param isCleanTime
     * @param bizOrgCode
     * @return
     */
    List<EquipmentSpecificAlarmLog> getAlarmLogInfoList(String equipmentCode, String nameKeys, String value, String isCleanTime, String bizOrgCode);

    /**
     * 获取设备物联日志
     *
     * @param
     * id：系统id
     * startTime：开始时间
     * endTime：结束时间
     * @return
     */
    Page<EquipmentAlarmLogDto> getEquipAlarmLog(String id, String startTime, String endTime, long pageSize, long current );
}
