package com.yeejoin.amos.boot.module.jczs.flc.api.service;


import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.RegUnitInfoDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 单位注册信息表接口类
 *
 * @author system_generator
 * @date 2022-08-09
 */
public interface IRegUnitInfoService {

    /**
     * 单位注册
     * @param model RegUnitInfoDto
     * @return RegUnitInfoDto
     */
    RegUnitInfoDto registerUnit(RegUnitInfoDto model);


    /**
     * 单位校验
     * @param unitCode 单位唯一编号
     * @param unitType 单位类型
     * @return RegUnitInfoDto
     */
    RegUnitInfoDto unitCheck(String unitCode, String unitType, String companyName);

    /**
     * 单位类型列表字典
     * @return List<DataDictionary>
     */
    List<DataDictionary> getUnitTypeList();

    /**
     * 获取管辖机构树
     * @return 组织架构中单位级别为：省级、地市级、区县级的单位
     */
    Collection getManagementUnitTree(String orgCode);

    /**
     * 单位注销
     * @param unitCode 单位唯一标识
     * @return 是否成功
     */
    Boolean unitLogOut(String unitCode);

    /**
     * 校验是否已经存在相同的账号
     * @param userName 账号
     * @return true 已存在相同账号，不能注册 false 不存在账号，可以注册
     */
    Boolean checkRepeatAccount(String userName);

    /**
     * 手机号重复校验
     * @param phoneNo 手机号
     * @return true 已存在不能注册 false 不存在可以注册
     */
    Boolean checkRepeatPhone(String phoneNo);

    void updateAdminInfo(JSONObject dataResult);

    Boolean creatQrCode();

    RegUnitInfoDto adminInfo(String unitCode);

    String submit(Long pageId, String taskId, String planInstanceId, String topic, String tableName, Map<String, Object> objectMap) throws Exception;
}
