package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 产权单位处理器
 */
@Component("estateUnitTypeHandler")
@RequiredArgsConstructor
public class EstateUnitTypeHandler implements TypeHandler<String> {
    private final Map<String, String> CODE_NAME_MAP = new ConcurrentHashMap<>();

    private final CommonMapper commonMapper;

    @Override
    public String handle(String unitCreditCode) {
        return unitCreditCode != null ? CODE_NAME_MAP.computeIfAbsent(unitCreditCode,
                (k) -> commonMapper.queryUnitNameByCreditCode(unitCreditCode)) : null;
    }
}
