package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.Getter;

/**
 * 风险报告状态枚举
 */
@Getter
public enum RiskReportStage {

    /**
     * 草稿状态
     */
    DRAFT("草稿"),

    /**
     * 监管处置
     */
    SUPERVISION("监管处置"),

    /**
     * 企业整改
     */
    COMPANY_RECTIFICATION("企业整改");

    private final String name;

    RiskReportStage(String name) {
        this.name = name;
    }

    /**
     * 根据中文名称获取枚举
     */
    public static RiskReportStage fromName(String name) {
        for (RiskReportStage status : values()) {
            if (status.name.equals(name)) {
                return status;
            }
        }
        return null;
    }
}