package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgBasicInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgConstructionInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgDesignInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgElevatorTechInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgInspectionInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgMaintenanceInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgOtherInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgProduceInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgRegistrationInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgSuperviseInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzsJgUseInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.PageParam;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgConstructionInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgDesignInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgElevatorTechInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgFile;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgInspectionInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgMaintenanceInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgOtherInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgProduceInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgRegistrationInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgSuperviseInfo;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsJgUseInfo;
import com.yeejoin.amos.boot.module.tzs.api.enums.JgFileAttributeEnum;
import com.yeejoin.amos.boot.module.tzs.api.enums.JgFileObjectEnum;
import com.yeejoin.amos.boot.module.tzs.api.mapper.TzsJgMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgConstructionInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgDesignInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgElevatorTechInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgFileService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgInspectionInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgMaintenanceInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgOtherInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgProduceInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgRegistrationInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgSuperviseInfoService;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsJgUseInfoService;

@Service
public class TzsJgServiceImpl implements ITzsJgService {

	@Autowired
	TzsJgMapper tzsJgMapper;

	@Autowired
	ITzsJgSuperviseInfoService iTzsJgSuperviseInfoService;

	@Autowired
	ITzsJgDesignInfoService iTzsJgDesignInfoService;

	@Autowired
	ITzsJgProduceInfoService iTzsJgProduceInfoService;

	@Autowired
	ITzsJgRegistrationInfoService iTzsJgRegistrationInfoService;

	@Autowired
	ITzsJgUseInfoService iTzsJgUseInfoService;

	@Autowired
	ITzsJgConstructionInfoService iTzsJgConstructionInfoService;

	@Autowired
	ITzsJgMaintenanceInfoService iTzsJgMaintenanceInfoService;

	@Autowired
	ITzsJgInspectionInfoService iTzsJgInspectionInfoService;

	@Autowired
	ITzsJgElevatorTechInfoService iTzsJgElevatorTechInfoService;

	@Autowired
	ITzsJgOtherInfoService iTzsJgOtherInfoService;

	@Autowired
	ITzsJgFileService iTzsJgFileService;

	/**
	 * 文件服务器地址
	 */
	@Value("${fileserver.domain}")
	String fileServerUrl;

	@Override
	public IPage<TzsJgBasicInfoDto> page(PageParam pageParam, TzsJgBasicInfoDto tzsJgBasicInfoDto) {
		Page<TzsJgBasicInfoDto> page = new Page<>(pageParam.getCurrent(), pageParam.getSize());
		return tzsJgMapper.page(page, tzsJgBasicInfoDto);
	}

	@Override
	public TzsJgBasicInfoDto detail(String code) {
		TzsJgBasicInfoDto dto = new TzsJgBasicInfoDto();
		TzsJgSuperviseInfo superviseInfo = iTzsJgSuperviseInfoService
				.getOne(new LambdaQueryWrapper<TzsJgSuperviseInfo>().eq(TzsJgSuperviseInfo::getSequenceCode, code));
		TzsJgSuperviseInfoDto superviseInfoDto = new TzsJgSuperviseInfoDto();
		if (superviseInfo != null) {
			BeanUtils.copyProperties(superviseInfo, superviseInfoDto);
		}
		TzsJgDesignInfo designInfo = iTzsJgDesignInfoService
				.getOne(new LambdaQueryWrapper<TzsJgDesignInfo>().eq(TzsJgDesignInfo::getSequenceCode, code));
		TzsJgDesignInfoDto designInfoDto = new TzsJgDesignInfoDto();
		if (designInfo != null) {
			BeanUtils.copyProperties(designInfo, designInfoDto);
			List<TzsJgFile> designFile = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.DESIGN_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.DESIGN_FILE.getAttribute()));
			designFile.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			List<TzsJgFile> designCode = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.DESIGN_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.DESIGN_CODE.getAttribute()));
			designCode.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			designInfoDto.setDesignFile(designFile);
			designInfoDto.setDesignCode(designCode);
		}
		TzsJgProduceInfo produceInfo = iTzsJgProduceInfoService
				.getOne(new LambdaQueryWrapper<TzsJgProduceInfo>().eq(TzsJgProduceInfo::getSequenceCode, code));
		TzsJgProduceInfoDto produceInfoDto = new TzsJgProduceInfoDto();
		if (produceInfo != null) {
			BeanUtils.copyProperties(produceInfo, produceInfoDto);
			List<TzsJgFile> produceStandard = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.PRODUCE_STANDARD.getAttribute()));
			List<TzsJgFile> productCertificate = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.PRODUCT_CERTIFICATE.getAttribute()));
			List<TzsJgFile> iumInstructions = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.IUM_INSTRUCTIONS.getAttribute()));
			List<TzsJgFile> supervisionCert = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.SUPERVISION_CERT.getAttribute()));
			List<TzsJgFile> ceCert = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.PRODUCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.CE_CERT.getAttribute()));
			produceStandard.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			productCertificate.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			iumInstructions.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			supervisionCert.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			ceCert.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			produceInfoDto.setProduceStandard(produceStandard);
			produceInfoDto.setProductCertificate(productCertificate);
			produceInfoDto.setIumInstructions(iumInstructions);
			produceInfoDto.setSupervisionCert(supervisionCert);
			produceInfoDto.setCeCert(ceCert);
		}
		TzsJgRegistrationInfo registrationInfo = iTzsJgRegistrationInfoService.getOne(
				new LambdaQueryWrapper<TzsJgRegistrationInfo>().eq(TzsJgRegistrationInfo::getSequenceCode, code));
		TzsJgRegistrationInfoDto registrationInfoDto = new TzsJgRegistrationInfoDto();
		if (registrationInfo != null) {
			BeanUtils.copyProperties(registrationInfo, registrationInfoDto);
			List<TzsJgFile> useRegistCertificate = iTzsJgFileService.list(new LambdaQueryWrapper<TzsJgFile>()
					.eq(TzsJgFile::getSequenceCode, code)
					.eq(TzsJgFile::getObjectType, JgFileObjectEnum.REGISTRATION_INFO.getObject())
					.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.USE_REGIST_CERTIFICATE.getAttribute()));
			useRegistCertificate.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			registrationInfoDto.setUseRegistCertificate(useRegistCertificate);
		}
		TzsJgUseInfo useInfo = iTzsJgUseInfoService
				.getOne(new LambdaQueryWrapper<TzsJgUseInfo>().eq(TzsJgUseInfo::getSequenceCode, code));
		TzsJgUseInfoDto useInfoDto = new TzsJgUseInfoDto();
		if (useInfo != null) {
			BeanUtils.copyProperties(useInfo, useInfoDto);
		}
		TzsJgConstructionInfo constructionInfo = iTzsJgConstructionInfoService
				.getOne(new LambdaQueryWrapper<TzsJgConstructionInfo>().eq(TzsJgConstructionInfo::getSequenceCode, code)
						.orderByDesc(TzsJgConstructionInfo::getRecDate).last("limit 1"));
		TzsJgConstructionInfoDto constructionInfoDto = new TzsJgConstructionInfoDto();
		if (constructionInfo != null) {
			BeanUtils.copyProperties(constructionInfo, constructionInfoDto);
		}
		TzsJgMaintenanceInfo maintenanceInfo = iTzsJgMaintenanceInfoService
				.getOne(new LambdaQueryWrapper<TzsJgMaintenanceInfo>().eq(TzsJgMaintenanceInfo::getSequenceCode, code)
						.orderByDesc(TzsJgMaintenanceInfo::getRecDate).last("limit 1"));
		TzsJgMaintenanceInfoDto maintenanceInfoDto = new TzsJgMaintenanceInfoDto();
		if (maintenanceInfo != null) {
			BeanUtils.copyProperties(maintenanceInfo, maintenanceInfoDto);
			List<TzsJgFile> repairInform = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.MAINTENANCE_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.REPAIR_INFORM.getAttribute()));
			repairInform.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			maintenanceInfoDto.setRepairInform(repairInform);
		}
		TzsJgInspectionInfo inspectionInfo = iTzsJgInspectionInfoService
				.getOne(new LambdaQueryWrapper<TzsJgInspectionInfo>().eq(TzsJgInspectionInfo::getSequenceCode, code)
						.orderByDesc(TzsJgInspectionInfo::getRecDate).last("limit 1"));
		TzsJgInspectionInfoDto inspectionInfoDto = new TzsJgInspectionInfoDto();
		if (inspectionInfo != null) {
			BeanUtils.copyProperties(inspectionInfo, inspectionInfoDto);
			List<TzsJgFile> inspectionReport = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.INSPECTION_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.INSPECTION_REPORT.getAttribute()));
			inspectionReport.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			inspectionInfoDto.setInspectionReport(inspectionReport);
		}
		TzsJgOtherInfo otherInfo = iTzsJgOtherInfoService
				.getOne(new LambdaQueryWrapper<TzsJgOtherInfo>().eq(TzsJgOtherInfo::getSequenceCode, code));
		TzsJgOtherInfoDto otherInfoDto = new TzsJgOtherInfoDto();
		if (otherInfo != null) {
			BeanUtils.copyProperties(otherInfo, otherInfoDto);
		}
		TzsJgElevatorTechInfo elevatorTechInfo = iTzsJgElevatorTechInfoService.getOne(
				new LambdaQueryWrapper<TzsJgElevatorTechInfo>().eq(TzsJgElevatorTechInfo::getSequenceCode, code));
		TzsJgElevatorTechInfoDto elevatorTechInfoDto = new TzsJgElevatorTechInfoDto();
		if (elevatorTechInfo != null) {
			BeanUtils.copyProperties(elevatorTechInfo, elevatorTechInfoDto);
			List<TzsJgFile> governorEffiReport = iTzsJgFileService
					.list(new LambdaQueryWrapper<TzsJgFile>().eq(TzsJgFile::getSequenceCode, code)
							.eq(TzsJgFile::getObjectType, JgFileObjectEnum.ELEVATOR_TECH_INFO.getObject())
							.eq(TzsJgFile::getAttributeType, JgFileAttributeEnum.GOVERNOR_EFFI_REPORT.getAttribute()));
			governorEffiReport.forEach(i -> i.setFileUrl(fileServerUrl + i.getFileUrl()));
			elevatorTechInfoDto.setGovernorEffiReport(governorEffiReport);
		}
		dto.setSequenceCode(code);
		if (superviseInfo != null) {
			dto.setSuperviseCode(superviseInfo.getSuperviseCode());
			dto.setOrgBranchName(superviseInfo.getOrgBranchName());
		}
		if (useInfo != null) {
			dto.setUseUnitName(useInfo.getUseUnitName());
			dto.setEstateUnitName(useInfo.getEstateUnitName());
			dto.setArea(useInfo.getProvince() + "/" + useInfo.getCity() + "/" + useInfo.getCounty());
			dto.setAddress(useInfo.getAddress());
		}
		if (maintenanceInfo != null) {
			dto.setMeUnitName(maintenanceInfo.getMeUnitName());
		}
		if (registrationInfo != null) {
			dto.setEquCode(registrationInfo.getEquCode());
			dto.setEquDefine(registrationInfo.getEquDefine());
			dto.setEquCategory(registrationInfo.getEquCategory());
			dto.setUseOrgCode(registrationInfo.getUseOrgCode());
		}
		if (otherInfo != null) {
			dto.setCode96333(otherInfo.getCode96333());
		}
		if (produceInfo != null) {
			dto.setFactoryNum(produceInfo.getFactoryNum());
		}
		dto.setSuperviseInfo(superviseInfoDto);
		dto.setDesignInfo(designInfoDto);
		dto.setProduceInfo(produceInfoDto);
		dto.setRegistrationInfo(registrationInfoDto);
		dto.setUseInfo(useInfoDto);
		dto.setElevatorTechInfo(elevatorTechInfoDto);
		dto.setConstructionInfo(constructionInfoDto);
		dto.setMaintenanceInfo(maintenanceInfoDto);
		dto.setInspectionInfo(inspectionInfoDto);
		dto.setOtherInfo(otherInfoDto);
		return dto;
	}

}
