package com.yeejoin.amos.boot.module.common.biz.refresh.factory;

import com.yeejoin.amos.boot.module.common.api.service.IDataRefreshHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class RefreshHandlerFactory {
    private final List<IDataRefreshHandler> handlers;

    private final Map<String, List<IDataRefreshHandler>> handlerMap = new ConcurrentHashMap<>();


    public List<IDataRefreshHandler> getRefreshHandler(String dataType) {
        return handlerMap.computeIfAbsent(dataType, (k) -> handlers.stream().filter(handler->handler.supportType().equals(dataType)).collect(Collectors.toList()));
    }

}
