package com.yeejoin.amos.boot.module.cylinder.api.enums;

/**
        * @description: 基础枚举类

        **/
public enum BaseExceptionEnum {
    /**
     * 请求成功
     */
    SUCCESS(0, "请求成功"),
    /**
     * 系统繁忙
     */
    SYSTEM_BUSY(100, "系统繁忙"),
    /**
     * 请求超时
     */
    REQUEST_TIME_OUT(300, "请求超时"),
    /**
     * 参数错误
     */
    PARAMETER_ERROR(400, "参数错误"),
    /**
     * 网络异常
     */
    NETWORK_ERROR(404, "网络异常"),
    /**
     * 数据不存在
     */
    DATA_NOT_EXISTS(600, "数据不存在"),
    /**
     * 无权访问
     */
    ACCESSDENIED_ERROR(501, "无权访问"),
    /**
     * 请求已经过期
     */
    REQUEST_EXPIRATION(406, "请求已经过期"),
    /**
     * 请求失败
     */
    REQUEST_ERROR(407, "请求失败"),
    /**
     * 未知错误
     */
    FAILURE(999, "未知错误");
    private Integer code;
    private String msg;

    BaseExceptionEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

