package com.yeejoin.amos.supervision.business.service.intfc;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.supervision.business.vo.InputItemTemplateVo;
import com.yeejoin.amos.supervision.business.vo.InputItemVo;
import com.yeejoin.amos.supervision.business.vo.PointInputItemVo;
import org.springframework.data.domain.Page;

import com.yeejoin.amos.supervision.business.param.InputItemPageParam;
import com.yeejoin.amos.supervision.business.util.DaoCriteria;
import com.yeejoin.amos.supervision.dao.entity.InputItem;

/**
 * 检查项业务处理实体
 *
 * @author gaodongdong
 */
public interface IInputItemService {
    /**
     * 新增检查项
     *
     * @param inputItem 检查项
     * @return
     */
    public long addNewInputItem(InputItem inputItem);

    /**
     * 查询检查项详情
     *
     * @param id
     * @return
     */
    public InputItem queryInputItemDetail(Long id);

    /**
     * 修改检查项
     *
     * @param inputItem 检查项
     */
    public void updateInputItem(InputItem inputItem);

    /**
     * 删除检查项
     *
     * @param id
     */
    public void delInputItem(Long id);


    /**
     * 分页条件查询检查项
     *
     * @param criterias
     * @return
     */
    public Page<InputItemVo> queryInputItemByPage(InputItemPageParam criterias);

    /**
     * 条件查询检查项
     *
     * @param criterias
     * @return
     */
    public List<InputItem> queryInputItemByCondition(List<DaoCriteria> criterias);

    /**
     * 条件查询检查项个数
     *
     * @param params
     * @return
     */
    public int queryInputItemCountByCondition(List<DaoCriteria> criterias);

    /**
     * 另存为
     *
     * @param ids
     * @param long1
     */
    public void saveAs(String[] ids, String userId);

    /**
     * 批量删除检查项
     *
     * @param ids
     */
    public void batchDelInputItem(String[] ids);

    /**
     * 获取组织下所有巡检项
     *
     * @param loginOrgCode
     * @return
     */
    public String[] queryInputItemNames(String loginOrgCode);


    public List<String> qryItemNoList(List<DaoCriteria> criterias, Long itemId);

    /**
     * 获取组织下所有巡检项
     *
     * @param dictCode
     * @return
     */
    public Object getMaintenanceClassify(String token, String product, String appKey, String dictCode);

    List<PointInputItemVo> queryCustomInputItem(Map<String, Object> param, String orgCode);

    Boolean uploadListByTemplate(List<InputItemTemplateVo> itemTemplateVoList, String orgCode, String userId) throws Exception;

    Integer insertList(List<InputItem> list);

    List generateDictionaryValue();

    List getItemParent(String id);

    void updatePointById(Map<String, Object> param);
}
