package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * 工作经历
 *
 * @author tb
 * @date 2021-06-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_firefighters_workexperience")
@ApiModel(value = "FirefightersWorkexperience对象", description = "工作经历")
public class FirefightersWorkexperience extends BaseEntity {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "参加工作时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date workingHours;

	@ApiModelProperty(value = "参加消防部门工作时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date fireWorkingHours;

	@ApiModelProperty(value = "人员id")
	private Long firefightersId;

	@ApiModelProperty(value = "更新时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date updateTime;
}
