package com.yeejoin.amos.boot.module.common.biz.controller;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Date;
import java.util.List;

import com.yeejoin.amos.boot.module.common.biz.service.impl.ContractServiceImpl;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.ContractDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;


/**
 * 维保合同
 *
 * @author system_generator
 * @date 2021-07-16
 */
@RestController
@Api(tags = "维保合同Api")
@RequestMapping(value = "/common/contract")
public class ContractController extends BaseController {

    @Autowired
    ContractServiceImpl contractServiceImpl;

    /**
     * 新增维保合同
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增维保合同", notes = "新增维保合同")
    public ResponseModel<ContractDto> save(@RequestBody ContractDto model) {
        model = contractServiceImpl.saveModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 更新合同信息及附件
     *
     * @param model
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "更新合同信息及附件", notes = "更新合同信息及附件")
    public ResponseModel<ContractDto> updateBySequenceNbrContract(@RequestBody ContractDto model,
                                                                  @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(contractServiceImpl.updateById(model));
    }

    /**
     * 删除合同信息 (无约束)
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batch")
    @ApiOperation(httpMethod = "DELETE", value = "删除合同信息 (无约束)", notes = "删除合同信息 (无约束)")
    public ResponseModel<List<Long>> deleteBySequenceNbr(@RequestParam(value = "ids") String ids) throws Exception {
        return ResponseHelper.buildResponse(contractServiceImpl.multDeleteAircraft(RequestContext.getAgencyCode(),
                ids));
    }

    /**
     * 批量删除合同信息
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete_batch")
    @ApiOperation(httpMethod = "DELETE", value = "批量删除合同信息", notes = "批量删除合同信息")
    public ResponseModel<Boolean> batchDeleteBySequenceNbrList(@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList) {
        return ResponseHelper.buildResponse(contractServiceImpl.batchDelete(sequenceNbrList));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "查询单个维保合同", notes = "查询单个维保合同")
    public ResponseModel<ContractDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(contractServiceImpl.queryOne(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "维保合同分页查询", notes = "维保合同分页查询")
    public ResponseModel<Page<ContractDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, Long companyId, Long signedCompanyId, String name, Long typeCode,
                                                         String signedDate) {
        Page<ContractDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        AgencyUserModel amosUser = getUserInfo();
        return ResponseHelper.buildResponse(contractServiceImpl.queryForContractPage(page, false, companyId,
                signedCompanyId, name, typeCode, signedDate, amosUser.getUserId()));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "维保合同列表全部数据查询", notes = "维保合同列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ContractDto>> selectForList() {
        return ResponseHelper.buildResponse(contractServiceImpl.queryForContractList(false));
    }
}
