package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipInsuranceDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipInsurance;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEquipInsuranceServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 设备保险信息控制类
 * @author LiuLin
 * @date 2024-10-17
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-equip-insurance")
public class JgEquipInsuranceController extends BaseController {

    @Autowired
    JgEquipInsuranceServiceImpl jgEquipInsuranceServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<Object> save(@RequestBody JSONObject map) {
		return ResponseHelper.buildResponse(jgEquipInsuranceServiceImpl.save(map));
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/update")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<JgEquipInsurance> updateBySequenceNbrJgEquipInsurance(@RequestBody JgEquipInsurance entity,
																			   @RequestParam(value = "sequenceNbr") Long sequenceNbr) {
	    entity.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgEquipInsuranceServiceImpl.updateWithModel(entity));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/delete")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgEquipInsuranceServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getDetail")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<JgEquipInsuranceDto> getDetail(@RequestParam Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgEquipInsuranceServiceImpl.getDetail(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<JgEquipInsuranceDto>> queryForPage(@RequestParam(value = "sort", required = false) String sort,
															  @RequestParam(value = "current") int current,
															  @RequestParam(value = "size") int size,
															  JgEquipInsuranceDto dto){
		Page<JgEquipInsurance> page = new Page<>(current, size);
	    return ResponseHelper.buildResponse(jgEquipInsuranceServiceImpl.queryForJgEquipInsurancePage(page, sort, dto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgEquipInsurance>> selectForList() {
	    return ResponseHelper.buildResponse(jgEquipInsuranceServiceImpl.queryForJgEquipInsuranceList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "市级为维度,责任保险统计")
	@GetMapping(value = "/countLiabilityInsuranceStatisticsByCity")
	public ResponseModel<Map<String, Object>> countLiabilityInsuranceStatisticsByCity() {
		return ResponseHelper.buildResponse(jgEquipInsuranceServiceImpl.countLiabilityInsuranceStatisticsByCity());
	}
}
