package com.yeejoin.amos.boot.module.jg.biz.reminder.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImplService;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl.EQUIP_INFO_FORM_ID;

@Component
@RequiredArgsConstructor
public class CommonReminderService {

    private final IdxBizJgDesignInfoMapper idxBizJgDesignInfoMapper;

    private final IdxBizJgFactoryInfoMapper jgFactoryInfoMapper;

    private final IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    private final IdxBizJgUseInfoMapper idxBizJgUseInfoMapper;

    private final IdxBizJgOtherInfoMapper idxBizJgOtherInfoMapper;

    private final IdxBizJgSupervisionInfoMapper idxBizJgSupervisionInfoMapper;

    public static <T> T geEquipInfoFromJson(Map<String, Object> formData, Class<T> clazz) {
        LinkedHashMap equipmentInfoForm = (LinkedHashMap) checkAndCast(formData.get(EQUIP_INFO_FORM_ID));
        return JSON.parseObject(JSON.toJSONString(equipmentInfoForm), clazz);
    }

    private static Object checkAndCast(Object obj) {
        if (obj instanceof LinkedHashMap) {
            return obj;
        } else {
            throw new ClassCastException("对象类型不匹配");
        }
    }

    public static String getRegTypeForInsert(Map<String, Object> formData) {
        LinkedHashMap equipmentInfoForm = (LinkedHashMap) checkAndCast(formData.get(EQUIP_INFO_FORM_ID));
        String dataSource = equipmentInfoForm.get("DATA_SOURCE").toString();
        return "new".equals(dataSource) ? "0" : "his".equals(dataSource) ? "1" : "2";
    }

    public static String getRegTypeByDataSource(String dataSource) {
        if (dataSource.contains("jg_his_black")) {
            return "2";
        } else if (dataSource.contains("jg_his")) {
            return "1";
        } else {
            return "0";
        }
    }

    public static String getOneRecord(JSONObject data) {
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) data.get("equipmentLists");
        List<String> records = equipmentLists.stream().map(item -> item.get("record").toString()).collect(Collectors.toList());
        return records.iterator().next();
    }

    public void setMatchItemEquCategoryByRecord(MatchItemDto matchItemDto, String record) {
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper
                .selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>()
                        .eq(IdxBizJgRegisterInfo::getRecord, record)
                        .select(IdxBizJgRegisterInfo::getRecord, IdxBizJgRegisterInfo::getEquList, IdxBizJgRegisterInfo::getEquCategory, IdxBizJgRegisterInfo::getEquDefine));
        matchItemDto.setEquList(registerInfo.getEquList());
        matchItemDto.setEquCategory(registerInfo.getEquCategory());
        matchItemDto.setEquDefine(registerInfo.getEquDefine());
    }

    public static List<ReminderItemDto> setProjectReminderItemRealTime(String bizId, IdxBizJgProjectContraptionServiceImplService idxBizJgProjectContraptionServiceImpl) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionServiceImpl.getById(bizId);
        return setProjectReminderItemPageJson(bizId, projectContraption);
    }

    public static MatchItemDto setMatchItemForProject(MatchItemDto matchItemDto, IdxBizJgProjectContraption projectContraption) {
        matchItemDto.setEquList(projectContraption.getEquList());
        matchItemDto.setEquCategory(projectContraption.getEquCategory());
        matchItemDto.setEquDefine(projectContraption.getEquDefine());
        matchItemDto.setIsRegister(projectContraption.getIsIntoManagement() && StringUtils.isNotEmpty(projectContraption.getUseRegistrationCode()));
        matchItemDto.setRegType(CommonReminderService.getRegTypeByDataSource(projectContraption.getDataSource()));
        return matchItemDto;
    }

    public Map<String, Object> getEquipDetailByRecord(String record) {
        Map<String, Object> re = new HashMap<>();
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record));
        IdxBizJgFactoryInfo factoryInfo = jgFactoryInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord, record));
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, record));
        IdxBizJgDesignInfo designInfo = idxBizJgDesignInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgDesignInfo>().eq(IdxBizJgDesignInfo::getRecord, record));
        IdxBizJgOtherInfo otherInfo = idxBizJgOtherInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgOtherInfo>().eq(IdxBizJgOtherInfo::getRecord, record));
        IdxBizJgSupervisionInfo idxBizJgSupervisionInfo = idxBizJgSupervisionInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgSupervisionInfo>().eq(IdxBizJgSupervisionInfo::getRecord, record));
        re.putAll(BeanUtil.beanToMap(useInfo));
        re.putAll(BeanUtil.beanToMap(registerInfo));
        re.putAll(BeanUtil.beanToMap(factoryInfo));
        re.putAll(BeanUtil.beanToMap(otherInfo));
        re.putAll(BeanUtil.beanToMap(designInfo));
        re.putAll(BeanUtil.beanToMap(idxBizJgSupervisionInfo));
        return re;
    }

    public static List<ReminderItemDto> setProjectReminderItemPageJson(String bizId, IdxBizJgProjectContraption projectContraption) {
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(bizId);
        reminderItemDto.setEquipNo(projectContraption.getProjectContraptionNo());
        reminderItemDto.setEquipName(projectContraption.getProjectContraption());
        reminderItemDto.setDetailData(BeanUtil.beanToMap(projectContraption));
        return Collections.singletonList(reminderItemDto);
    }

    public void setEquCateInfoForEdit(String record, MatchItemDto matchItemDto) {
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>()
                .eq(IdxBizJgRegisterInfo::getRecord, record)
                .select(TzsBaseEntity::getSequenceNbr,
                        IdxBizJgRegisterInfo::getRecord,
                        IdxBizJgRegisterInfo::getEquCategory,
                        IdxBizJgRegisterInfo::getEquDefine,
                        IdxBizJgRegisterInfo::getEquList,
                        IdxBizJgRegisterInfo::getWhetherVehicleCylinder));
        matchItemDto.setEquList(registerInfo.getEquList());
        matchItemDto.setEquCategory(registerInfo.getEquCategory());
        matchItemDto.setEquDefine(registerInfo.getEquDefine());
        matchItemDto.setWhetherVehicleCylinder(StringUtils.isNotEmpty(registerInfo.getWhetherVehicleCylinder()) ? registerInfo.getWhetherVehicleCylinder() : "0");
    }
}
