package com.yeejoin.amos.boot.module.jg.biz.service;


import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * JG表格数据导出接口类
 */
public interface IJgTableDataExportService {

    void startDownLoadMsg(String fileName, String uuid);

    void gen(String jsonName, String voName, String tableName);

    void certificate(String uuid, JgUseRegistrationManageDto dto, Boolean isJG, List<String> ids, String sort);

    void maintenance(HttpServletResponse response, List<String> ids);

    void installation(HttpServletResponse response, List<String> ids);

    void maintain(HttpServletResponse response, List<String> ids);

    void reform(HttpServletResponse response, List<String> ids);

    void transfer(HttpServletResponse response, List<String> ids);

    void registration(HttpServletResponse response, JgUseRegistrationDto dto, String client);

    void changeRegistrationUnit(HttpServletResponse response, List<String> ids);

    void changeRegistrationReform(HttpServletResponse response, List<String> ids);

    void enableDisable(HttpServletResponse response, List<String> ids);

    void scrapCancel(HttpServletResponse response, List<String> ids);

    void changeRegistrationTransfer(HttpServletResponse response, List<String> ids);

    void changeRegistrationName(HttpServletResponse response, List<String> ids);

    void vehicleInformation(HttpServletResponse response, List<String> ids);

    void changeVehicleRegistrationUnit(HttpServletResponse response, List<String> ids);

    void unregulatedEquip(String uuid, Map<String, Object> map);

    void manageEquipment(String uuid, Map<String, Object> map);

    void equipTransfer(HttpServletResponse response, List<String> ids);

    void managePipe(String uuid, Map<String, String> params, String sort, ReginParams reginParams);

    void unregulatedPipe(String uuid, Map<String, String> params, String sort, ReginParams reginParams);

    void enterpriseInformationExport(String uuid, String ids, Map<String, Object> map);

    void userInfoExport(String uuid, String ids, Map<String, Object> map);

    void userInfoExportWithAdmin(String uuid, String ids, Map<String, Object> map);
}
