package com.yeejoin.amos.boot.module.statistics.api.dto;

import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 用户保存的自定义筛选内容表
 *
 * @author system_generator
 * @date 2025-06-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TzsCustomFilterContentDto", description = "用户保存的自定义筛选内容表")
public class TzsCustomFilterContentDto extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "所属业务（综合统计分析：zhtjfx）")
    private String businessType;

    @ApiModelProperty(value = "所属单位code")
    private String orgCode;

    @ApiModelProperty(value = "所属单位名称")
    private String orgName;

    @ApiModelProperty(value = "筛选条件名称")
    private String filterName;

    @ApiModelProperty(value = "筛选条件内容")
    private Object filterContent;

    @ApiModelProperty(value = "选择筛选条件后全部中展示的内容")
    private Object filterResult;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "筛选条件类型")
    private String filterType;

}
