package com.yeejoin.amos.boot.module.tcm.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.AlertCalledRecordDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.AlertPaperInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.WechatMyBusinessListDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.WechatMyBussinessDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.AlertCalled;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 警情接警填报记录 Mapper 接口
 *
 * @author litw
 * @date 2021-08-03
 */
public interface AlertCalledMapper extends BaseMapper<AlertCalled> {

    /**
     * 接警情况统计
     *
     * @param beginDate
     * @param endDate
     * @return
     */
   List<Map<String, Integer>> queryNearlyCount(@Param("beginDate") String beginDate,
                                               @Param("endDate") String endDate,
                                               @Param("orgCode") String orgCode,
                                               @Param("recUserId") String recUserId
   );
    /**
     * 接警情况统计
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    Map<String, Integer> queryAlertStatusCount(@Param("beginDate") String beginDate,
                                               @Param("endDate") String endDate,
                                               @Param("orgCode") String orgCode,
                                               @Param("recUserId") String recUserId
    );

    /**
     * 根据查询条件返回警情记录
     * @param workOrderNumber
     * @return
     */
    Page<List<AlertCalledQueryDto>> queryAlertListByQueryDto(
            IPage<AlertCalledQueryDto> page,
            @Param("workOrderNumber") String workOrderNumber,
            @Param("creator") String creator,
            @Param("emergency") String emergency,
            @Param("emergencyTimeStart") String emergencyTimeStart,
            @Param("emergencyTimeEnd") String emergencyTimeEnd,
            @Param("emergencyCall") String emergencyCall,
            @Param("deviceId") String deviceId,
            @Param("elevatorAddress") String elevatorAddress,
            @Param("district") String district,
            @Param("alertType") String alertType,
            @Param("alertSource") String alertSource,
            @Param("alertStage") String alertStage,
            @Param("alertStatus") String alertStatus,
            @Param("sortParam") String sortParam,
            @Param("sortRule") String sortRule,
            @Param("userIds") Set<String> userIds);

    Map<String, Integer> getTodayEmergencyCount(String regionCode);
    
	Map<String, Integer> getImportantEventCount(String regionCode);


    List<Map<String, Object>> getImportantEventDetail(String type, String regionCode);

    List<Map<String, Object>> getTodayEmergencyDetail(String rescueTotal, String rescueComplete, String regionCode);

    WechatMyBussinessDto getBussinessInfoById(@Param("alertId") Long alertId);

    List<WechatMyBusinessListDto> getBussinessListByPhonePager(@Param("phone") String phone, @Param("bussinessCode") String bussinessCode, @Param("current") Long current);

 /**
  * 根据条件返回接警记录信息
  * @param callTimeStart
  * @param callTimeEnd
  * @param type
  * @param alertSource
  * @param alarmType
  * @return
  */
 List<AlertCalledRecordDto> queryAlertRecordListByQueryDto(
         String callTimeStart,
         String callTimeEnd,
         String type,
         String alertSource,
         String alarmType);

 List<AlertPaperInfoDto> getAlertPaperInfoList(@Param("regionCodes") List<String> regionCodes, @Param("isHistory") Boolean isHistory);

 Integer getEquipmentHistoryCount(@Param("regionCodes") List<String> regionCodes, @Param("equipmentClassCode") String equipmentClassCode, @Param("equipmentCode") String equipmentCode);

 List<AlertPaperInfoDto> getEquipmentHistory(@Param("regionCodes") List<String> regionCodes, @Param("equipmentClassCode") String equipmentClassCode, @Param("current") Integer current, @Param("pageNum") Integer pageNum, @Param("equipmentCode") String equipmentCode);

 @Select("select count(1) from tz_alert_called where rec_user_name =#{userName} and rec_date >= #{startTime} and rec_date <= #{endTime}")
 Integer getCountNum(String userName, Date startTime, Date endTime);
}
