package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tcm.api.entity.BaseUnitLicence;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.BaseUnitLicenceServiceImpl;
import com.yeejoin.amos.boot.module.tcm.flc.biz.service.impl.RegUnitInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@RestController
@Api(tags = "临时api")
@RequestMapping(value = "/temporary")
public class TemporaryController extends BaseController {

    @Autowired
    RegUnitInfoServiceImpl regUnitInfoService;

    @Autowired
    BaseUnitLicenceServiceImpl baseUnitLicenceService;

    /**
     * 刷新许可信息表中的发证机关code
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "刷新许可信息表中的发证机关code", notes = "刷新许可信息表中的发证机关code")
    @GetMapping(value = "/brushData")
    public ResponseModel<String> brushData() {
        Map<?, ?> dictOfDJJGMap = regUnitInfoService.dictOfDJJG();
        // 许可信息
        List<BaseUnitLicence> unitLicences = baseUnitLicenceService.list(new LambdaQueryWrapper<BaseUnitLicence>().isNull(BaseUnitLicence::getApprovedOrganCode));
        List<BaseUnitLicence> updatedLicenses = unitLicences.stream().peek(licence -> {
            String approvedOrgan = licence.getApprovedOrgan();
            String approvedOrganCode = (String) dictOfDJJGMap.getOrDefault(approvedOrgan, null);
            licence.setApprovedOrganCode(approvedOrganCode);
        }).collect(Collectors.toList());

        baseUnitLicenceService.saveOrUpdateBatch(updatedLicenses);
        return ResponseHelper.buildResponse("ok");
    }
}
