package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 字典枚举对象
 * @author maoying
 *
 */
public enum DictTypeEnum {
    controlMeasuresCategory("管控措施类别","CM_CATEGORY"),
    controlMeasuresType("管控措施类型","CM_TYPE"),
    TASKWORKTYPE("作业活动类型", "TASKWORK_TYPE"),
    EQUIPTYPE("设备类型","EQUIP_TYPE"),
    DANGERLEVEL("隐患等级", "DANGER_LEVEL"),
    OUTERPOINTTYPE("导入外部安全检查表分类", "OUTER_POINT_TYPE"),
    CHECK_CLASSIFY("检查分类","CHECK_CLASSIFY");
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    private DictTypeEnum(String name, String code){
        this.name = name;
        this.code = code;
    }

    public static DictTypeEnum getEnum(String code) {
        DictTypeEnum instance = null;
        for(DictTypeEnum type: DictTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String,String>> list = new ArrayList<>();
        for(DictTypeEnum e : DictTypeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
