package com.yeejoin.amos.patrol.business.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.business.constants.XJConstant;
import com.yeejoin.amos.patrol.business.dao.mapper.PointMapper;
import com.yeejoin.amos.patrol.business.dao.mapper.RouteMapper;
import com.yeejoin.amos.patrol.business.dao.mapper.RoutePointItemMapper;
import com.yeejoin.amos.patrol.business.dao.repository.IRouteDao;
import com.yeejoin.amos.patrol.business.dao.repository.IRoutePointDao;
import com.yeejoin.amos.patrol.business.feign.JcsFeignClient;
import com.yeejoin.amos.patrol.business.feign.TzsFeign;
import com.yeejoin.amos.patrol.business.param.RoutePageParam;
import com.yeejoin.amos.patrol.business.service.impl.RouteServiceImpl;
import com.yeejoin.amos.patrol.business.service.intfc.IRouteService;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.business.util.RoutePageParamUtil;
import com.yeejoin.amos.patrol.core.async.AsyncTask;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.request.CommonRequest;
import com.yeejoin.amos.patrol.core.common.request.RoutePointInputItemRequest;
import com.yeejoin.amos.patrol.core.common.request.ToJson;
import com.yeejoin.amos.patrol.core.common.response.RoutePointRespone;
import com.yeejoin.amos.patrol.dao.entity.*;
import com.yeejoin.amos.patrol.feign.RemoteSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import liquibase.pro.packaged.S;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.weaver.ast.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/api/route")
@Api(tags="巡检路线api")
public class RouteController extends AbstractBaseController {

	private final Logger log = LoggerFactory.getLogger(RouteController.class);

	@Autowired
	private IRouteService routeService;
	
	@Autowired
	private AsyncTask asyncTask;
	@Autowired
	private RemoteSecurityService remoteSecurityService;

	@Autowired
	private JcsFeignClient jcsFeignClient;

	@Resource
	private RoutePointItemMapper routePointItemMapper;
	@Autowired
	private IRoutePointDao iRoutePointDao;
	@Autowired
	private RouteServiceImpl routeServiceImpl;


	@Autowired
	private IRouteDao iRouteDao;

	@Autowired
	private TzsFeign tzsFeign;

	@Resource
	private RouteMapper routeMapper;

	@Autowired
	PointMapper pointMapper;

	/**
	 *
	 * 新增接口
	 * **/


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询巡检路线信息", notes = "查询巡检路线信息")
	@PostMapping(value = "/listNew", produces = "application/json;charset=UTF-8")
	public CommonResponse listRouteNew(
			@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) RoutePageParam queryRequests,
			@ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
		try {
			HashMap<String, Object> map = new HashMap<>(16);
			map.put("name", "气瓶");
			map.put("code", "2300");
			map.put("type", "cylinder");
			List<Map<String, Object>> result = tzsFeign.getEnterpriseType().getResult();
			List<Map<String, Object>> getEquipType = tzsFeign.getEquipType().getResult();
			getEquipType.add(map);
			if (org.springframework.util.StringUtils.isEmpty(queryRequests.getBizOrgCode())) {
				ReginParams reginParams = getSelectedOrgInfo();
				//获取所在公司code
				String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
				queryRequests.setBizOrgCode(bizOrgCode);
			}
			if (commonPageable != null) {
				queryRequests.setPageNumber(commonPageable.getPageNumber() - 1);
				queryRequests.setPageSize(commonPageable.getPageSize());
			}
			Page<HashMap<String, Object>> routeList = routeService.getRouteInfo(null,null,null,queryRequests);
			routeList.stream().forEach(item -> {
				List<Map<String, Object>> enterpriseTypeList = result.stream().filter(enterpriseType -> enterpriseType.get("code").toString().equals(item.get("enterpriseType").toString())).collect(Collectors.toList());
				List<Map<String, Object>> equipTypeList = getEquipType.stream().filter(equipType -> equipType.get("code").toString().equals(item.get("equipType").toString())).collect(Collectors.toList());
				if (!ObjectUtils.isEmpty(enterpriseTypeList)){
					item.put("enterpriseType", enterpriseTypeList.get(0).get("name"));
				}
				if (!ObjectUtils.isEmpty(equipTypeList)){
					item.put("equipType", equipTypeList.get(0).get("name"));
				}
			});

			return CommonResponseUtil.success(routeList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询巡检路线信息失败");
		}
	}




	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询所有路线列表<font color='blue'>手机app</font>", notes = "查询所有路线列表<font color='blue'>手机app</font>")
	@GetMapping(value = "/routeListNew", produces = "application/json;charset=UTF-8")
	public CommonResponse queryRouteListNew() {
		try {

			ReginParams reginParams = getSelectedOrgInfo();


			List<HashMap<String, Object>> routeList = routeService.queryRouteListByOrgCodeNew(reginParams.getPersonIdentity().getBizOrgCode(),null);
			routeList=routeList.stream().distinct().collect(Collectors.toList());
			return CommonResponseUtil.success(routeList);
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
	}






	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询当前登录公司的的所有巡检路线", notes = "查询当前登录公司的的所有巡检路线")
	@GetMapping(value = "/AllNew", produces = "application/json;charset=UTF-8")
	public CommonResponse queryAllRouteNew(@ApiParam(value = "是否是迁移巡查点页面 （1-是  0或空-不是）") @RequestParam(required = false) Integer isRemove) {
		try {

			ReginParams reginParams = getSelectedOrgInfo();
			String orgCode =reginParams.getPersonIdentity().getBizOrgCode();
			//2.查询
			List<Route> routeList = routeService.queryRouteListNew(orgCode);
			List<Route> list = routeList.stream().filter(e -> e.getIsExist().equals("true")).collect(Collectors.toList());



			return CommonResponseUtil.success(!Objects.isNull(isRemove) && 1 == isRemove ? (routeList!=null?ToJson.tojson(routeList):null) : (list!=null?ToJson.tojson(list):null));
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询巡检路线信息失败");
		}
	}

	/**
	 * 修改保存巡检路线
	 * @return IDs
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "新*保存巡检路线", notes = "新*保存巡检路线")
	@PutMapping(value = "/saveUpdateNew", produces = "application/json;charset=UTF-8")
	public CommonResponse saveRouteNew(@ApiParam(value = "巡检路线", required = true) @RequestBody Route route) {
		try {
			ReginParams reginParams = getSelectedOrgInfo();
			String loginOrgCode = getOrgCode(reginParams);
			route.setOrgCode(loginOrgCode);


//			if(!StringUtils.isEmpty(route.getName())){
//                List<Route> list =null;
//
//               list = route.getId()>0?iRouteDao.getListByNameUpdate(route.getId(),route.getName()):iRouteDao.getListByName(route.getName());
//
//                if (!ObjectUtils.isEmpty(list) || list.size()>0){
//					throw new BadRequest("该名称路线已存在");
//				}
//			}
//			if(route.getDeptId()!=null){
//				//查询jcs
//				ResponseModel<Object> companyInfo = jcsFeignClient.getCompanyInfo(route.getDeptId());
//				Object obj = companyInfo.getResult();
//				String bizOrgName = ((Map<String, Object>) obj).get("bizOrgName").toString();
//				route.setDeptName(bizOrgName);
//				route.setBizOrgCode(((Map<String, Object>) obj).get("bizOrgCode").toString());
//				route.setBizOrgName(bizOrgName);
//			}
//			if(route.getBoss()!=null){
//				//查询jcs
//				FeignClientResult result = jcsFeignClient.selectById(route.getBoss());
//				Object obj = result.getResult();
//				String bizOrgName = ((Map<String, Object>) obj).get("personName").toString();
//				route.setBossName(bizOrgName);
//			}
			Integer integer = routeMapper.checkData(route.getId(), route.getName());
			if (integer > 0){
				throw new BadRequest("该名称路线已存在");
			}
			route.setCreatorId(getUserId());
			route.setBizOrgCode(reginParams.getPersonIdentity().getBizOrgCode());
			route.setBizOrgName(reginParams.getCompany().getCompanyName());
			return CommonResponseUtil.success(routeService.addRouteNew(route));
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure(e.getMessage());
		}
	}

	/**
	 * 根据ID查询巡检路线信息
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询巡检路线信息", notes = "查询巡检路线信息")
	@GetMapping(value = "/queryRouteByIdNew", produces = "application/json;charset=UTF-8")
	public CommonResponse queryRouteByIdNew(
			@ApiParam(value = "巡检路线id", required = true) @RequestParam(name = "id") long id) {
		try {
			Route route = routeService.queryRouteById(id);
			return CommonResponseUtil.success(route);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询巡检路线失败");
		}
	}
	

	/**
	 * 删除巡检路线
	 *
	 * @param routeIds
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除巡检路线", notes = "删除巡检路线")
	@DeleteMapping(value = "/deleteRouteNew", produces = "application/json;charset=UTF-8")
	public CommonResponse deleteRouteNew(@ApiParam(value = "巡检路线ID", required = false) @RequestParam List<Long> routeIds) {
		try {
			//校验1：线路上有点时返回删除失败
			Map<Long, String> idNameMap = new HashMap<>();
			for (long id : routeIds) {
				int routePointCount = routeService.countRoutePoint(id);
				if (routePointCount > 0) {
					Route route = routeService.queryRouteById(id);
					idNameMap.put(id, route.getName());
				}
			}
			if (idNameMap.size() > 0) {
				return CommonResponseUtil.failure(idNameMap, "删除路线失败：路线上已设置巡检点");
			}
			//校验2：计划在使用，删除失败
			idNameMap.clear();
			for (long id : routeIds) {
				int routePointCount = routeService.countRoutePoint(id);
				if (routePointCount > 0) {
					List<Plan> planList = routeService.queryPlanByRouteId(id);
					if(planList != null && planList.size() >0){
						idNameMap.put(id, planList.get(0).getName());
					}
				}
			}
			if (idNameMap.size() > 0) {
				return CommonResponseUtil.failure(idNameMap, "删除路线失败：计划在使用");
			}

			routeService.delRouteById(routeIds.toArray(new Long[0]));

			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("删除巡检路线失败");
		}
	}




	/**
	 * 增加巡检路线
	 * 
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "新增巡检路线", notes = "新增巡检路线")
	@PostMapping(value = "/addRoute", produces = "application/json;charset=UTF-8")
	public CommonResponse addRoute(@ApiParam(value = "巡检路线", required = true) @RequestBody Route route) {
		try {
			 ReginParams reginParams = getSelectedOrgInfo();
	            String loginOrgCode = getOrgCode(reginParams);
			route.setOrgCode(loginOrgCode);
			route.setIsDelete(false);
			if (routeService.existRouteName(loginOrgCode, route.getName())) {
				return CommonResponseUtil.failure("巡检路线名称重复");
			}
			
			
			
			route.setCreatorId(getUserId());
			Route newRoute = routeService.addRoute(route);
			List<Long> routeIds = new ArrayList<>();
			routeIds.add(newRoute.getId());
			//asyncTask.pushRouteTo3D(routeIds);
			pushRouteTo3D(getToken(), getProduct(), getAppKey(),routeIds);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			e.printStackTrace();
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("巡检路线新增失败");
		}
	}

	
	


	@Async
    public void pushRouteTo3D(String toke,String product,String appKey,List<Long> ids ){
    	
    	 try {
			asyncTask.pushRouteTo3D( toke, product, appKey,ids);
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
        
    }
	/**
	 * 更新巡检路线
	 * 
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "更新巡检路线", notes = "更新巡检路线")
	@PutMapping(value = "/updateRoute", produces = "application/json;charset=UTF-8")
	public CommonResponse updateRoute(@ApiParam(value = "巡检路线", required = true) @RequestBody Route route) {
		try {
			 ReginParams reginParams = getSelectedOrgInfo();
	            String orgCode = getOrgCode(reginParams);
			route.setOrgCode(orgCode);
			route.setCreatorId(getUserId());
			Route newRoute = routeService.updateRoute(route);
			List<Long> routeIds = new ArrayList<>();
			routeIds.add(newRoute.getId());
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("巡检路线更新失败");
		}
	}

	/**
	 * 删除巡检路线
	 * 
	 * @param routeIds
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除巡检路线", notes = "删除巡检路线")
	@DeleteMapping(value = "/deleteRoute", produces = "application/json;charset=UTF-8")
	public CommonResponse deleteRoute(@ApiParam(value = "巡检路线ID", required = false) @RequestParam List<Long> routeIds) {
		try {
			//校验1：线路上有点时返回删除失败
			Map<Long, String> idNameMap = new HashMap<>();
			for (long id : routeIds) {
				int routePointCount = routeService.countRoutePoint(id);
				if (routePointCount > 0) {
					Route route = routeService.queryRouteById(id);
					idNameMap.put(id, route.getName());
				}
			}
			if (idNameMap.size() > 0) {
				return CommonResponseUtil.failure(idNameMap, "删除路线失败：路线上已设置巡检点");
			}
			//校验2：计划在使用，删除失败
			idNameMap.clear();
			for (long id : routeIds) {
				int routePointCount = routeService.countRoutePoint(id);
				if (routePointCount > 0) {
					List<Plan> planList = routeService.queryPlanByRouteId(id);
					if(planList != null && planList.size() >0){
						idNameMap.put(id, planList.get(0).getName());
					}
				}
			}
			if (idNameMap.size() > 0) {
				return CommonResponseUtil.failure(idNameMap, "删除路线失败：计划在使用");
			}
			
			routeService.delRouteById(routeIds.toArray(new Long[0]));
			
			//asyncTask.pushRouteTo3D(routeIds);
			pushRouteTo3D(getToken(), getProduct(), getAppKey(),routeIds);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("删除巡检路线失败");
		}
	}

	/**
	 * 根据ID查询巡检路线信息
	 * 
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询巡检路线信息", notes = "查询巡检路线信息")
	@GetMapping(value = "/queryRouteById/{id}", produces = "application/json;charset=UTF-8")
	public CommonResponse queryRouteById(
			@ApiParam(value = "巡检路线id", required = true) @PathVariable(name = "id") long id) {
		try {
			Route route = routeService.queryRouteById(id);
			return CommonResponseUtil.success(route);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询巡检路线失败");
		}
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "迁移路线上点到其他路线", notes = "迁移路线上点到其他路线")
	@PostMapping(value = "/migrateRoutePoint", produces = "application/json;charset=UTF-8")
	public CommonResponse migrateRoutePoint(
			@ApiParam(value = "当前巡检路线id", required = true) @RequestParam(name = "sourceRouteId") Long sourceRouteId,
			@ApiParam(value = "巡检点id", required = true) @RequestParam(name = "pointIds") List<Long> pointIds,
			@ApiParam(value = "迁移目标巡检路线id", required = true) @RequestParam(name = "targetRouteId") Long targetRouteId) {
		try {
			routeService.migrateRoutePoint(sourceRouteId, pointIds.toArray(new Long[0]), targetRouteId);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("巡检点迁移失败");
		}
	}

	/**
	 * 查询巡检路线信息
	 * 
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询巡检路线信息", notes = "查询巡检路线信息")
	@PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
	public CommonResponse listRoute(
			@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
			@ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
		try {
			ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getOrgCode(reginParams);
			HashMap<String,Object> paramMap = new HashMap<String,Object>();
			paramMap.put("orgCode",loginOrgCode);
			RoutePageParam params = RoutePageParamUtil.fillRouteInfoParam(queryRequests, commonPageable, paramMap);
			Page<HashMap<String, Object>> routeList = routeService.getRouteInfo(getToken(),getProduct(),getAppKey(),params);
        	
        	Set<Object> userIds = new HashSet();
        	Set<Object> depIds =new HashSet();
        	routeList.getContent().forEach(item ->{
                Object boss = item.get("boss");
                if( !ObjectUtils.isEmpty(boss) && !userIds.contains(boss)) {
                	userIds.add(boss);
    			}
                Object bossDeptId = item.get("dept_id");
    			if(!ObjectUtils.isEmpty(bossDeptId) && !depIds.contains(bossDeptId)){
    				depIds.add(bossDeptId);
        		}
        	});	
        	
        	Map<String,String> userRealNameMap = remoteSecurityService.getUserRealName(getToken(),getProduct(),getAppKey(), userIds);
        	Map<Long,String> depName = remoteSecurityService.getDepName(getToken(), getProduct(), getAppKey(), depIds);
        	
        	if( routeList != null  ) {
        		routeList.getContent().forEach(item ->{
        			Object boss = item.get("boss");
        			if(!ObjectUtils.isEmpty(boss) && userRealNameMap.containsKey(boss.toString())){
        				item.put("boss",userRealNameMap.get(boss.toString()));  
        			}
        			Object deptId = item.get("dept_id"); 
        			if(!ObjectUtils.isEmpty(deptId) && depName.containsKey(Long.valueOf(deptId.toString()))){
        				item.put("deptName",depName.get(Long.valueOf(deptId.toString())));  
        			}
        		});       		
        	}
			return CommonResponseUtil.success(routeList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询巡检路线信息失败");
		}
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询当前登录公司的的所有巡检路线", notes = "查询当前登录公司的的所有巡检路线")
	@GetMapping(value = "/All", produces = "application/json;charset=UTF-8")
	public CommonResponse queryAllRoute() {
		try {
			//1.组织数据权限信息
//			List<DaoCriteria> criterias = new ArrayList<DaoCriteria>();
			 //1.组织数据权限信息
            ReginParams reginParams = getSelectedOrgInfo();
            String orgCode = getOrgCode(reginParams);
//			DaoCriteria compDaoCriteria = new DaoCriteria();
//			compDaoCriteria.setPropertyName("orgCode");
//			compDaoCriteria.setOperator(QueryOperatorEnum.LIKE.getName());
//			compDaoCriteria.setValue(orgCode);
//			criterias.add(compDaoCriteria);
			//2.查询
			List<Route> routeList = routeService.queryRouteList(orgCode);
			return CommonResponseUtil.success(routeList);	
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询巡检路线信息失败");
		}
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询所有路线列表<font color='blue'>手机app</font>", notes = "查询所有路线列表<font color='blue'>手机app</font>")
	@GetMapping(value = "/routeList", produces = "application/json;charset=UTF-8")
	public CommonResponse queryRouteList() {
		try {
			AgencyUserModel userModel = getUserInfo();
            String userId = "";
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = "";
            String departmentId = "";
            String roleTypeName = getRoleTypeName(reginParams);

			if(XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase()) || XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())){
				loginOrgCode = getOrgCode(reginParams);
			}else if(XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())){
				departmentId = getDepartmentId(reginParams);
				loginOrgCode = getOrgCode(reginParams);
				userId = userModel.getUserId();
			}else if(XJConstant.ROLE_NAME_PERSON.equals(roleTypeName.toUpperCase())){
				userId = userModel.getUserId();
				loginOrgCode = getOrgCode(reginParams);
			}
			List<HashMap<String, Object>> routeList = routeService.queryRouteListByOrgCode(loginOrgCode,userId,departmentId);
			routeList=routeList.stream().distinct().collect(Collectors.toList());
			return CommonResponseUtil.success(routeList);
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
	}

	/**
	 * 查询巡检路线上点列表
	 * 
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询巡检路线上点列表", notes = "查询巡检路线上点列表")
	@PostMapping(value = "/listRoutePoint", produces = "application/json;charset=UTF-8")
	public CommonResponse listRoutePoint(@ApiParam(value = "路线id", required = true) @RequestParam long routeId,
			@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
			@ApiParam(value = "分页参数", required = true, defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable) {
		try {
			 String uid = getUserId();
	            ReginParams reginParams = getSelectedOrgInfo();
	            String orgCode = getOrgCode(reginParams);
			HashMap<String, Object> reqParam = new HashMap<>();
			reqParam.put("orgCode", orgCode);
			RoutePageParamUtil.fillRouteInfo(queryRequests, reqParam);
			Page<RoutePointRespone> pointList = routeService.queryRoutePoints(routeId, reqParam, commonPageable);
			return CommonResponseUtil.success(pointList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询巡检路线上点列表失败");
		}
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询巡检路线上点列表", notes = "查询巡检路线上点列表")
	@PutMapping(value = "/exchangeOrderNumber", produces = "application/json;charset=UTF-8")
	public CommonResponse exchangeRoutePointOrderNumber(@ApiParam(value = "路线巡检点id", required = true) @RequestParam long src, 
			@ApiParam(value = "路线巡检点id", required = true) @RequestParam long target) {
		if (src > 0 && target > 0) {
			routeService.exchangeRoutePointOrderNumber(src, target);
		} 
		return CommonResponseUtil.success();
	}

	/**
	 * 巡检路线上增加巡检点
	 * 
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "巡检路线上增加巡检点", notes = "巡检路线上增加巡检点")
	@PostMapping(value = "/addRoutePoint", produces = "application/json;charset=UTF-8")
	public CommonResponse addRoutePoint(@ApiParam(value = "路线id", required = true) @RequestParam String routeId,
			@ApiParam(value = "巡检点ids", required = true) @RequestParam List<String> pointIds) {
		
		if(pointIds == null || pointIds.size() <=0 ){
			return CommonResponseUtil.failure("巡检点不能为空，请选择");
		}
		
		try {
			 String uid = getUserId();
	            ReginParams reginParams = getSelectedOrgInfo();
	            String loginOrgCode = getOrgCode(reginParams);
			List<RoutePoint> routePointList = new ArrayList<>();
			for (String pointId : pointIds) {
				RoutePoint routePoint = new RoutePoint();
				routePoint.setRouteId(Long.parseLong(routeId));
				routePoint.setPointId(Long.parseLong(pointId));
				routePoint.setOrgCode(loginOrgCode);
				routePoint.setCreatorId(uid);
				routePointList.add(routePoint);
			}
			routeService.addRoutePoint(routePointList);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("巡检路线上增加巡检点失败");
		}
	}

	/**
	 * 巡检路线上删除巡检点
	 * 
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "巡检路线上删除巡检点", notes = "巡检路线上删除巡检点")
	@DeleteMapping(value = "/deleteRoutePoint", produces = "application/json;charset=UTF-8")
	public CommonResponse deleteRoutePoint(@ApiParam(value = "路线id", required = true) @RequestParam Long routeId,
			@ApiParam(value = "巡检点ids", required = true) @RequestParam List<Long> pointIds) {

		try {
			routeService.deleteRoutePoint(routeId, pointIds.toArray(new Long[0]));
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("巡检路线上删除巡检点失败");
		}
	}

	/**
	 * 列出巡检线路点的巡检项
	 * 
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "列出巡检线路点的巡检项", notes = "列出巡检线路点的巡检项")
	@PostMapping(value = "/listRoutePointInputItem", produces = "application/json;charset=UTF-8")
	public CommonResponse listRoutePointInputItem(@ApiParam(value = "路线id", required = true) @RequestBody RoutePointInputItemRequest request) {
		try {
			HashMap<String, Object> routePointInputItemList = routeService.listRoutePointInputItem(request);
			return CommonResponseUtil.success(routePointInputItemList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("列出巡检线路点的巡检项失败");
		}
	}

	/**
	 * 列出巡检线路点的分类及巡检项
	 * 
	 * @param routeId
	 * @param pointId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "列出巡检线路点的分类及巡检项", notes = "列出巡检线路点的分类及巡检项")
	@PostMapping(value = "/listRoutePointInputItemWithClassify", produces = "application/json;charset=UTF-8")
	public CommonResponse listRoutePointInputItemWithClassify(@ApiParam(value = "路线id", required = true) @RequestParam long routeId,
			@ApiParam(value = "巡检点id", required = true) @RequestParam long pointId) {
		try {
			Map<String, List<InputItem>> classifiedInputItemMap = routeService.listRoutePointInputItemWithClassify(routeId, pointId);
			return CommonResponseUtil.success(classifiedInputItemMap);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("列出巡检线路点的分类及巡检项失败");
		}
	}
	
	/**
	 * 修改巡检线路点的巡检项
	 * 
	 * @param routeId
	 * @param pointId
	 * @param inputItemIds
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "修改巡检线路点的巡检项", notes = "修改巡检线路点的巡检项")
	@PostMapping(value = "/updateRoutePointInputItem", produces = "application/json;charset=UTF-8")
	public CommonResponse updateRoutePointInputItem(@ApiParam(value = "巡检路线id", required = true) @RequestParam Long routeId, 
			@ApiParam(value = "巡检点id", required = true) @RequestParam Long pointId,
			@ApiParam(value = "巡检点巡检项id", required = true) @RequestParam List<Long> inputItemIds) {
		try {
			routeService.updateRoutePointInputItem(routeId, pointId, inputItemIds.toArray(new Long[0]));
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("修改巡检线路点的巡检项失败");
		}
	}


	/**
	 * 修改巡检线路点的巡检项
	 *
	 * @param routeId
	 * @param pointId
	 * @param inputItemIds
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "修改巡检线路点的巡检项新", notes = "修改巡检线路点的巡检项新")
	@PostMapping(value = "/updateRoutePointInputItemNew", produces = "application/json;charset=UTF-8")
	public CommonResponse updateRoutePointInputItemNew(@ApiParam(value = "巡检路线id", required = true) @RequestParam(value = "routeId") Long routeId,
													@ApiParam(value = "巡检点id", required = true) @RequestParam(value = "pointId") Long pointId,
													@ApiParam(value = "巡检点分类id") @RequestParam(value = "classifyId", required = false) Long classifyId,
													@ApiParam(value = "巡检点巡检项id", required = true) @RequestParam List<Long> inputItemIds) {
		try {
			routeService.updateRoutePointInputItemNew(routeId, pointId,classifyId, inputItemIds);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("修改巡检线路点的巡检项失败");
		}
	}


	/**
	 * 根据巡检路线ID获取该路线上的所有点ID
	 * @return IDs
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "获取巡检路线上的所有点ID", notes = "获取巡检路线上的所有点ID")
	@RequestMapping(value = "/points/{routeID}", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse getPointIDByRouyeId(@ApiParam(value = "巡检路线ID") @PathVariable(required = true) Long routeID) {
		List<Long> pointIDs = routeService.getPointIDByRouyeId(routeID);
		return CommonResponseUtil.success(pointIDs);
	}
	
	/**
	 * 根据巡检路线ID获取该路线上的所有点ID
	 * @return IDs
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "获取巡检路线上的所有点ID", notes = "获取巡检路线上的所有点ID")
	@RequestMapping(value = "/points", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse getPointIDByRouteId(@ApiParam(value = "巡检路线ID信息") @RequestBody(required = true) Map routeInfo) {
		List<String> routeIdList = (List<String>) routeInfo.get("routeIDs");
		LinkedHashMap<String, Object> routePointIdMap = routeService.getPointIdByRouteId(routeIdList);
		return CommonResponseUtil.success(routePointIdMap);
	}

	/**
	 * 修改保存巡检路线
	 * @return IDs
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "新*保存巡检路线", notes = "新*保存巡检路线")
	@PutMapping(value = "/save-new", produces = "application/json;charset=UTF-8")
	public CommonResponse updateRouteNew(@ApiParam(value = "巡检路线", required = true) @RequestBody Route route) {
		try {
			ReginParams reginParams = getSelectedOrgInfo();
			String orgCode = getOrgCode(reginParams);
			route.setOrgCode(orgCode);
			route.setCreatorId(getUserId());
			return CommonResponseUtil.success(routeService.updateRouteNew(route));
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("巡检路线更新失败");
		}
	}

	/**
	 * 修改保存巡检路线
	 * @return IDs
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "巡检路线关联巡检点", notes = "巡检路线关联巡检点")
	@PutMapping(value = "/relevancyPoint", produces = "application/json;charset=UTF-8")
	public CommonResponse relevancyPoint(@ApiParam(value = "巡检路线", required = true) @RequestBody JSONObject map) {
		Route route = new Route();
		List<String> ids = (List<String>) map.get("ids");
		List<RoutePoint> routePoint = new ArrayList<>();
		for (String id : ids) {
			RoutePoint routePointItem = new RoutePoint();
			routePointItem.setPointId(Long.parseLong(id));
			routePoint.add(routePointItem);
		}

//		if (!ObjectUtils.isEmpty(ids)){
//			ids.forEach(item ->{
//				RoutePoint routePoint = new RoutePoint();
//				routePoint.setId(Long.valueOf(item.intValue()));
//				routePoints.add(routePoint);
//			});
//		}
		route.setId(Long.parseLong(map.get("routeId").toString()));
		route.setRoutePointList(routePoint);

		try {
			ReginParams reginParams = getSelectedOrgInfo();
			String orgCode = getOrgCode(reginParams);
			route.setOrgCode(orgCode);
			route.setCreatorId(getUserId());
			//判断当前点，是不是已经绑定到当前线路上

			List<Long> poi=	route.getRoutePointList().stream().map(p->p.getPointId()).collect(Collectors.toList());

			List<RoutePoint> list = iRoutePointDao.queryRoutePoint(route.getId(),poi.toArray(new Long[poi.size()]));
			if(list.size()>0){
				return CommonResponseUtil.failure("有巡检点已绑定，不能重复绑定！");
			}
			
			return CommonResponseUtil.success(routeService.relevancyPoint(route));
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("巡检路线更新失败");
		}
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除线路点", notes = "删除线路点")
	@PutMapping(value = "/delPoint", produces = "application/json;charset=UTF-8")
	public CommonResponse delPoint(@ApiParam(value = "巡检点id", required = true) @RequestParam List<Long> pointIds) {
		try {
			for (Long pointId : pointIds) {
				// 删除点的检查项项
				routePointItemMapper.delRoutePointItemByPointId(pointId);
				// 删除点
				iRoutePointDao.delRoutePointByPointId(pointId);
			}
        return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("删除线路点失败");
		}
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除线路绑定点", notes = "删除线路绑定点")
	@PostMapping(value = "/delRoutePoint", produces = "application/json;charset=UTF-8")
	public CommonResponse delRoutePoint( @RequestParam("pointIds") List<Long> pointIds,
										 @RequestParam("routeId") String routeId) {
		try {
			for (Long pointId : pointIds) {
				// 删除点的检查项
				routePointItemMapper.delRoutePointItem(routeId, pointId);
				// 删除路线绑定点关系
				routePointItemMapper.delRoutePoint(routeId, pointId);
			}
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("删除线路点失败");
		}

	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询企业类型", notes = "查询企业类型")
	@GetMapping(value = "/getEnterpriseType", produces = "application/json;charset=UTF-8")
	public CommonResponse getEnterpriseType() {
		return CommonResponseUtil.success(tzsFeign.getEnterpriseType().getResult());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询设备类型", notes = "查询设备类型")
	@GetMapping(value = "/getEquipType", produces = "application/json;charset=UTF-8")
	public CommonResponse getEquipType() {
		List<Map<String, Object>> result = tzsFeign.getEquipType().getResult();
		HashMap<String, Object> map = new HashMap<>(16);
		map.put("name", "气瓶");
		map.put("code", "2300");
		map.put("type", "cylinder");
		result.add(map);
		return CommonResponseUtil.success(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "路线绑定点列表", notes = "路线绑定点列表")
	@GetMapping(value = "/selectRoutePointList", produces = "application/json;charset=UTF-8")
	public CommonResponse selectRoutePointList(@RequestParam("size") Long size,
											   @RequestParam("number") Long number,
											   @RequestParam("routeId") String routeId,
											   @RequestParam(value = "name", required = false) String name,
											   @RequestParam(value = "pointNo", required = false) String pointNo){
		com.baomidou.mybatisplus.extension.plugins.pagination.Page<Point> pointPage = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
		number = (number -1) * size;
		pointPage.setTotal(pointMapper.countRoutePointList(name, pointNo,routeId));
		pointPage.setRecords(pointMapper.selectRoutePointList(number, size, name, pointNo,routeId));
		return CommonResponseUtil.success(pointPage);
	}
}
