package com.yeejoin.amos.patrol.business.service.intfc;

import com.yeejoin.amos.patrol.business.entity.mybatis.EquipmentInputItemRo;
import com.yeejoin.amos.patrol.business.util.Toke;
import com.yeejoin.amos.patrol.dao.entity.InputItem;

import java.util.HashMap;
import java.util.List;

/**
 * @author keyong
 * @title: IEquipmentHandler
 * <pre>
 * @description: 站端接受装备信息系统数据处理流程
 * </pre>
 * @date 2020/11/10 18:01
 */
public interface IEquipmentHandlerService {
    /**
     * 规则系统发起请求
     *
     * @param map
     * @param toke
     * @return
     */
    void fireEquipRuleMessagePush(HashMap<String,Object> map, Toke toke);
    /**
     * 根据code和装备名称查询装备
     *
     * @param orgCode
     * @param equipmentName
     * @return
     */

    public List<InputItem> getEquipmnetRules(String orgCode, String equipmentName);
    /**
     * 根据code和装备名称查询装备
     *
     * @return
     */
    public List<InputItem> getEquipmnetRulesByName( String equipmentName);

    /**
     * 根据code和装备名称查询装备
     *
     * @param rulesCheckList
     * @param toke
     * @return
     */
    public void getRulesCheckResult(List<EquipmentInputItemRo> rulesCheckList , Toke toke);


}
