package com.yeejoin.amos.boot.module.ymt.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 气瓶充卸统计表
 *
 * @author system_generator
 * @date 2022-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderFillingUnloadDataDto", description="气瓶充卸统计表")
public class CylinderFillingUnloadDataDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "充装总量")
    private Double fillingSum;

    @ApiModelProperty(value = "卸液总量")
    private Double unloadSum;

    @ApiModelProperty(value = "充卸日期")
    private Date statisDate;

    @ApiModelProperty(value = "充卸日期字符串")
    private String statisDateStr;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "充卸年份")
    private String statisYear;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "充卸月份")
    private String statisMonth;

}
