package com.yeejoin.amos.boot.module.common.api.enums;

import java.util.*;

/**
 * 警情枚举类
 */
public enum JYJCResultEnum {
    //警情类型
    KRJY("960","困人救援","JQLX", false),
    GZWX("961","故障维修","JQLX", false),
    TSZX("962","投诉咨询","JQLX", false),

    //检测结果
    HG("6040","合格","YYJG", true),
    BHG("6041","不合格","YYJG", true),
    FJHG("6042","复检合格","YYJG", true),
    FJBHG("6043","复检不合格","YYJG", true),
    QT("6044","其他","YYJG", true),
    ZGHHG("6045","整改后合格","YYJG", true),
    FY("6046","符合","YYJG", true),
    BFH("6047","不符合","YYJG", true),
    FHYQ("6048","符合要求","YYJG", true),
    JBFHYQ("6049","基本符合要求","YYJG", true),
    BFHYQ("6050","不符合要求","YYJG", true),
    YXSY("6051","允许使用","YYJG", true),
    JYSY("6052","降压使用","YYJG", true),
    JXHYSYPJ("6053","进行合于使用评价","YYJG", true),

    ;


    private JYJCResultEnum(String code, String name, String type, Boolean isSearch){
        this.code=code;
        this.name=name;
        this.type=type;
        this.isSearch=isSearch;
    }

    private String code;

    private String name;

    private String type;
    private Boolean isSearch;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
    public String getType() {
        return type;
    }

    public Boolean getSearch() {
        return isSearch;
    }

    public static List<HashMap<String,Object>> getTypeEnumList() {
        List<HashMap<String, Object>> list = new ArrayList<>();
        for (JYJCResultEnum testEnum : EnumSet.allOf(JYJCResultEnum.class)) {
            if(!testEnum.getSearch()) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("title", testEnum.name);
                map.put("value", testEnum.code);
                list.add(map);
            }
        }
        return list;
    }

    public static Map<String,List<Map<String,Object>>> getSearchEnumList() {
        Map<String,List<Map<String,Object>>> searchMap = new HashMap<>();
        for (JYJCResultEnum testEnum : EnumSet.allOf(JYJCResultEnum.class)) {
            if(testEnum.getSearch()) {
                // 检查 searchMap 中是否存在 testEnum.type 对应的值
                List existingList = searchMap.get(testEnum.type);
                // 如果不存在，则创建一个新的 ArrayList
                if (existingList == null) {
                    existingList = new ArrayList<>();
                    searchMap.put(testEnum.type, existingList);
                }
                // 创建一个 map 并添加到 list 中
                HashMap<String, Object> map = new HashMap<>();
                map.put("title", testEnum.name);
                map.put("value", testEnum.code);
                existingList.add(map);

            }
        }
        return searchMap;
    }

}
