package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.biz.config.LocalBadRequest;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.jg.biz.feign.WorkFlowFeignService;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.workflow.model.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import java.util.List;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class CmWorkflowServiceImpl implements ICmWorkflowService {

    /**
     * 通过
     */
    public static String PASS_OPERATE = "0";

    /**
     * 驳回
     */
    public static String REJECT_OPERATE = "1";

    @Autowired
    private WorkFlowFeignService workFlowFeignService;

    @Override
    public List<ProcessTaskDTO> startBatch(ActWorkflowBatchDTO params) {
        List<ProcessTaskDTO> processTasks;
        try {
            log.info("开始请求工作流启动接口:/start/batch,请求参数：{}", JSONObject.toJSONString(params));
            processTasks = workFlowFeignService.startForBatch(params).getResult();
            log.info("请求工作流接口startBatch结束，返回结果：{}", JSONObject.toJSONString(processTasks));
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = getErrorMessage(e);
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流批量启动失败", e);
            throw new RuntimeException("调用工作流批量启动失败");
        }
        return processTasks;
    }

    private String getErrorMessage(BaseException e){
        String devMessage = e.getDevMessage();
        if(devMessage.contains(";")){
            String tempMsg = devMessage.split(";")[0];
            if(tempMsg.contains(":")){
                devMessage =  tempMsg.split(":")[1];
            } else {
                devMessage = tempMsg;
            }
        }
        return devMessage;
    }

    @Override
    public ProcessTaskDTO completeOrReject(String taskId, TaskResultDTO data, String operate) {
        ProcessTaskDTO processTaskDTO;
        try {
            if(PASS_OPERATE.equals(operate)){
                // 通过操作
                log.info("开始请求工作流-完成任务-接口:/complete/standard/{taskId},请求参数：{},{},{}", taskId, operate, JSONObject.toJSONString(data));
                processTaskDTO = workFlowFeignService.completeByTaskFroStandard(taskId, data).getResult();
            } else if(REJECT_OPERATE.equals(operate)) {
                // 驳回操作
                log.info("开始请求工作流-驳回任务-接口:/reject/{taskId},请求参数：{},{},{}", taskId, operate, JSONObject.toJSONString(data));
                processTaskDTO = workFlowFeignService.reject(taskId, data).getResult();
            } else {
                // 执行普通节点（提交）
                log.info("开始请求工作流完成任务接口:/complete/standard/{taskId},请求参数：{},{},{}", taskId, operate, JSONObject.toJSONString(data));
                processTaskDTO = workFlowFeignService.completeByTaskFroStandard(taskId, data).getResult();
            }
            log.info("请求工作流接口completeOrReject结束，返回结果：{}", JSONObject.toJSONString(processTaskDTO));
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = getErrorMessage(e);
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流完成任务接口失败", e);
            throw new RuntimeException("调用工作流完成任务接口失败");
        }
        return processTaskDTO;
    }

    @Override
    public ProcessTaskDTO rollBack(String processInstanceId) {
        log.info("开始请求工作流撤回接口:/rollBack/standard/{processInstanceId},请求参数：{}", processInstanceId);
        ProcessTaskDTO processTaskDTO = FeignUtil.remoteCall(() -> workFlowFeignService.rollBackTask(processInstanceId));
        log.info("请求工作流接口rollBack结束，返回结果：{}", JSONObject.toJSONString(processTaskDTO));
        return processTaskDTO;
    }


    @Override
    public ProcessTaskDTO assign(FlowTaskVo taskVo) {
        ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
        try {
            log.info("开始请求工作流转办任务接口:/assign/{taskVo},请求参数：{}", taskVo);
            processTaskDTO = workFlowFeignService.assign(taskVo).getResult();
            log.info("请求工作流接口assign结束，返回结果：{}", JSONObject.toJSONString(processTaskDTO));
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = getErrorMessage(e);
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流转办任务接口失败", e);
            throw new RuntimeException("调用工作流转办任务接口失败");
        }
        return processTaskDTO;
    }


    @Override
    public ProcessInstanceDTO stopProcess(String processInstanceId, String stopReason) {
        ProcessInstanceDTO processTaskDTO = new ProcessInstanceDTO();
        try {
            log.info("开始请求工作流终止流程接口:/stopProcess/{processInstanceId},请求参数：{}，{}", processInstanceId, stopReason);
            processTaskDTO = workFlowFeignService.stopProcess(processInstanceId, stopReason).getResult();
            log.info("请求工作流接口stopProcess结束，返回结果：{}", JSONObject.toJSONString(processTaskDTO));
        } catch (InnerInvokException e) {
            //拦截无审核人异常信息
            String devMessage = getErrorMessage(e);
            log.error(devMessage);
            throw new LocalBadRequest(devMessage);
        } catch (Exception e) {
            log.error("调用工作流终止流程任接口失败", e);
            throw new RuntimeException("调用工作流终止流程任接口失败");
        }
        return processTaskDTO;
    }
}
