package com.yeejoin.amos.boot.module.jyjc.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 
 *
 * @author system_generator
 * @date 2023-12-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "tz_jyjc_opening_application", autoResultMap = true)
public class JyjcOpeningApplication extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单位编码
     */
	@TableField("unit_code")
    private String unitCode;

    /**
     * 单位编码Name
     */
    @ApiModelProperty (value = "unit_code_name")
    private String unitCodeName;

    /**
     * 检测区域编码
     */
	@TableField(value = "detection_region", typeHandler = FastjsonTypeHandler.class)
    private List<String> detectionRegion;

    /**
     * 检测区域名称（冗余）
     */
	@TableField("detection_region_name")
    private String detectionRegionName;

    /**
     * 申请单号
     */
	@TableField("application_seq")
    private String applicationSeq;

    /**
     * 检验结果方式
     */
	@TableField("result_type")
    private String resultType;

    /**
     * 有效期至
     */
	@TableField("expiry_date")
    @JsonFormat (pattern = "yyyy-MM-dd")
    private Date expiryDate;

    /**
     * 受理日期（接收日期）
     */
	@TableField("accept_date")
    @JsonFormat (pattern = "yyyy-MM-dd")
    private Date acceptDate;

    /**
     * 状态
     */
	@TableField("status")
    private String status;
    /**
     * 状态
     */
    @TableField("status_name")
    private String statusName;
    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 申请时间
     */
    @TableField(value = "apply_time", fill = FieldFill.INSERT)
    protected Date applyTime;
    /**
     * 工作流执行角色
     */
    @TableField(value = "workflow_role")
    private String workflowRole;
    /**
     * 工作流实例ID
     */
    @TableField(value = "workflow_prostance_id")
    private String workflowProstanceId;
    /**
     * 工作流节点
     */
    @TableField (value = "workflow_active_key")
    private String workflowActiveKey;
    /**
     * 下一执行节点ids
     */
    @TableField("next_execute_ids")
    private String nextExecuteIds;
    /**
     * 发起人id用于撤回操作
     */
    @TableField(value = "promoter")
    private String promoter;

    @TableField(value = "create_user_id")
    private String createUserId;

    @TableField(value = "next_task_id")
    private String nextTaskId;

    @TableField(value = "next_execute_user_ids")
    private String nextExecuteUserIds;

    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;

    /**
     * 对接单位code
     */
    @TableField(value = "docking_unit_code")
    private String dockingUnitCode;

    /**
     * 开通的业务类型:jc-检测；jy-检验
     */
    @TableField(value = "open_biz_type")
    private String openBizType;
}
