package com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ZBGLImpl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.common.api.enums.IssueMainBodyEnum;
import com.yeejoin.amos.boot.module.common.api.enums.IssueTypeEnum;
import com.yeejoin.amos.boot.module.statistcs.biz.service.IZBGLService;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.mapper.ZBGLStatisticsMapper;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class DnztdwyhpmServiceImpl implements IZBGLService {
    @Resource
    private StCommonServiceImpl stCommonService;

    @Resource
    private ZBGLStatisticsMapper zbglStatisticsMapper;
    @Override
    public Map<String, Object> getChart(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<RegionModel> regionModels = stCommonService.setRegionIfRootParent(dpFilterParamForDetailDto.getCityCode());
        List<String> issueTypeList = IssueTypeEnum.getEnumCodeListByMainBody(IssueMainBodyEnum.COMPANY.getCode());
        List<Map<String,Object>> result =  regionModels.parallelStream().map(r -> {
            String orgCode = stCommonService.getAndSetOrgCode(r.getRegionCode()+"");
            DPFilterParamForDetailDto dpFilterParamForDetailDtoNew = new DPFilterParamForDetailDto();
            dpFilterParamForDetailDtoNew.setOrgCode(orgCode);
            Map<String, Object> itemResult = new HashMap<>();
            Map<String,Long> map = zbglStatisticsMapper.getDNZTDWYHPMChartData(dpFilterParamForDetailDtoNew,issueTypeList);
            if(map.get("allCount") != 0 && map.get("endCount") != 0){
                itemResult.put("rate",BigDecimal.valueOf(map.get("endCount")).divide(BigDecimal.valueOf(map.get("allCount")),2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
            }else{
                itemResult.put("rate","0");
            }
            itemResult.put("count",map.get("allCount"));
            itemResult.put("xdata",r.getRegionName());
            return itemResult;
        }).collect(Collectors.toList());

        Map<String,Object> returnMap = new HashMap<>();
        List<Map<String,Object>> legendData = new ArrayList<>();
        for(int i = 0;i<2; i++){
            Map<String,Object> map = new HashMap<>();
            if(i == 0){
                map.put("dataKey","count");
                map.put("value","隐患总数");
                map.put("chartType","bar");
            }else{
                map.put("dataKey","rate");
                map.put("value","完结率");
                map.put("chartType","line");
            }
            legendData.add(map);
        }
        returnMap.put("legendData",legendData);

        List xdata = new ArrayList();
        List count = new ArrayList();
        List rate = new ArrayList();
        Long sum = 0L;
        for(int i = 0;i<result.size();i++){
            sum = sum + (Long)result.get(i).get("count");
        }
        for(int i = 0;i<result.size();i++){
            xdata.add(result.get(i).get("xdata"));
            count.add(result.get(i).get("count") == null ? "0" : result.get(i).get("count")+"");
            rate.add(result.get(i).get("rate") == null ? "0" : result.get(i).get("rate")+"");
        }

        returnMap.put("xdata",xdata);
        returnMap.put("count",count);
        returnMap.put("rate",rate);

        return returnMap;
    }

    @Override
    public Page<Map<String, Object>> getPage(Page page,DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<RegionModel> regionModels = stCommonService.setRegionIfRootParent(dpFilterParamForDetailDto.getCityCode());
        List<Map<String,Object>> result =  regionModels.parallelStream().map(r -> {
            String orgCode = stCommonService.getAndSetOrgCode(r.getRegionCode()+"");
            DPFilterParamForDetailDto dpFilterParamForDetailDtoNew = new DPFilterParamForDetailDto();
            dpFilterParamForDetailDtoNew.setOrgCode(orgCode);
            Map<String, Object> itemResult = new HashMap<>();
            List<Map<String,Long>> list = zbglStatisticsMapper.getAYHLXYHSLPMPageData(dpFilterParamForDetailDtoNew);
            Long sum = 0L;
            for(int i = 0;i<list.size();i++){
                sum = sum + (Long)list.get(i).get("longValue");
            }
            for(int i = 0;i<list.size();i++){
                if(sum != 0 && (Long)list.get(i).get("longValue") != 0){
                    itemResult.put(list.get(i).get("fieldValueCode")+"",list.get(i).get("longValue")+" / "+new BigDecimal(list.get(i).get("longValue")+"").divide(BigDecimal.valueOf(sum),2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100)).stripTrailingZeros().toPlainString()+"%");
                }
            }
            itemResult.put("area",r.getRegionName());
            itemResult.put("sequenceNbr", UUID.fastUUID().toString());
            return itemResult;
        }).collect(Collectors.toList());
        page.setRecords(result);
        page.setTotal(result.size());
        return page;
    }

    @Override
    public List<Map<String, String>> getTitle(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<Map<String, String>> list = zbglStatisticsMapper.getTypeList("ISSUE_TYPE");
        for(int i = 0;i<list.size();i++){
            list.get(i).put("dataIndex",list.get(i).get("code"));
            list.get(i).put("title",list.get(i).get("name"));
        }
        Map<String,String> map = new HashMap<>();
        map.put("dataIndex","area");
        map.put("title","区域");
        list.add(0,map);
        return list;
    }
}
