package com.yeejoin.amos.boot.module.jyjc.biz.result.processor;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Sets;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.BizEmqPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.result.factory.support.SupportableResultDataProcessor;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionResultServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgInspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
@Slf4j
public class SingleEquipResultDataProcessor implements SupportableResultDataProcessor {

    private final CommonServiceImpl commonService;

    private final SnowflakeIdUtil sequence;

    private final IdxBizJgInspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    private final BizEmqPublisher bizEmqPublisher;

    private final UseInfoMapper useInfoMapper;

    private final JyjcInspectionResultServiceImpl inspectionResultService;

    private static final Set<String> SUPPORTED_TYPES = Sets.newHashSet(
            EquipmentClassifityEnum.GL.getCode(),
            EquipmentClassifityEnum.YLRQ.getCode(),
            EquipmentClassifityEnum.DT.getCode(),
            EquipmentClassifityEnum.QZJX.getCode(),
            EquipmentClassifityEnum.CC.getCode(),
            EquipmentClassifityEnum.YLSS.getCode(),
            EquipmentClassifityEnum.KYSD.getCode()
    );

    @Override
    public boolean support(String equList) {
        return SUPPORTED_TYPES.contains(equList);
    }

    @Override
    public void process(JyjcInspectionResult jyjcInspectionResult) {
        IdxBizJgInspectionDetectionInfo info = new IdxBizJgInspectionDetectionInfo();
        QueryWrapper<IdxBizJgInspectionDetectionInfo> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(IdxBizJgInspectionDetectionInfo::getResultSeq, jyjcInspectionResult.getSequenceNbr());
        List<IdxBizJgInspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
        String record;
        //1.检验信息插入或者高新
        if (CollectionUtils.isEmpty(list)) {
            fillInspectionFields(jyjcInspectionResult, info);
            info.setSequenceNbr(sequence.nextId() + "");
            inspectionDetectionInfoMapper.insert(info);
            record = info.getRecord();
            bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
        } else {
            info = list.get(0);
            fillInspectionFields(jyjcInspectionResult, info);
            inspectionDetectionInfoMapper.updateById(info);
            record = info.getRecord();
            bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
        }
        // 2.设备技术参数更新
        inspectionResultService.updateTechParam(jyjcInspectionResult.getSequenceNbr(), record);
        // 3.更新使用信息表最新的检验信息
        useInfoMapper.updateByRecord(jyjcInspectionResult.getEquipUnicode(), jyjcInspectionResult.getNextInspectionDate(), jyjcInspectionResult.getInspectionType(), jyjcInspectionResult.getApplicationNo());
        // 4.es更新下次检验日期
        commonService.updateEquipNextInspectDate(jyjcInspectionResult, jyjcInspectionResult.getEquipUnicode());
        // 发送数据刷新消息
        inspectionResultService.sendDataRefreshMsg(Collections.singleton(record));
    }

    private void fillInspectionFields(JyjcInspectionResult jyjcInspectionResult, IdxBizJgInspectionDetectionInfo info) {
        info.setInspectOrgName(jyjcInspectionResult.getInspectionTypeName());
        info.setInspectType(jyjcInspectionResult.getInspectionType());
        info.setRecord(jyjcInspectionResult.getEquipUnicode());
        info.setInspectDate(jyjcInspectionResult.getInspectionDate());
        info.setInspectStaff(getInspectUserName(jyjcInspectionResult));
        info.setInspectStaffCode(jyjcInspectionResult.getInspector());
        info.setInspectConclusion(jyjcInspectionResult.getInspectionConclusion());
        info.setProblemRemark(jyjcInspectionResult.getNonConformance());
        info.setNextInspectDate(jyjcInspectionResult.getNextInspectionDate());
        info.setSequenceCode(jyjcInspectionResult.getEquipUnicode());
        info.setResultSeq(jyjcInspectionResult.getSequenceNbr() + "");
        info.setInspectOrgCode(jyjcInspectionResult.getInspectionUnitCode());
        info.setInspectReportNo(jyjcInspectionResult.getResultNo());
        info.setRecDate(new Date());
    }

    private String getInspectUserName(JyjcInspectionResult model) {
        List<TzsUserInfo> userInfos = commonService.getUserInfosByUnitCode(model.getInspectionUnitCode());
        return userInfos.stream().filter(u -> model.getInspector().contains(u.getSequenceNbr() + "")).map(TzsUserInfo::getName).collect(Collectors.joining(","));
    }
}
