package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.module.common.api.enums.UserPostEnum;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzsUserInfoMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.List;

/**
 * @author Administrator
 */
@Service
@RequiredArgsConstructor
public class InspectionChargePersonServiceImpl {

    private final JyjcInspectionApplicationServiceImpl inspectionApplicationService;

    private final TzsUserInfoMapper userInfoMapper;

    public JyjcInspectionApplicationModel saveChargePersonData(String applicationSeq, JyjcInspectionApplicationModel model) {
        LambdaUpdateWrapper<JyjcInspectionApplication> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(JyjcInspectionApplication::getInspectionChargePerson, model.getInspectionChargePerson());
        updateWrapper.set(JyjcInspectionApplication::getRemark2, model.getRemark2());
        updateWrapper.eq(BaseEntity::getSequenceNbr, applicationSeq);
        inspectionApplicationService.update(updateWrapper);
        return model;
    }

    public List<TzsUserInfo> getUserList(CompanyBo company) {
        LambdaQueryWrapper<TzsUserInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TzsUserInfo::getUnitCode, company.getCompanyCode());
        queryWrapper.eq(com.yeejoin.amos.boot.biz.common.entity.BaseEntity::getIsDelete, false);
        // 业务负责人 待实现
        queryWrapper.like(TzsUserInfo::getNewPost, UserPostEnum.YWFZR.getCode());
        queryWrapper.isNotNull(TzsUserInfo::getAmosUserId);
        queryWrapper.select(com.yeejoin.amos.boot.biz.common.entity.BaseEntity::getSequenceNbr, TzsUserInfo::getAmosUserId, TzsUserInfo::getName);
        return userInfoMapper.selectList(queryWrapper);
    }
}
