package com.yeejoin.equipmanage.common.utils;

import com.yeejoin.equipmanage.common.enums.UnitEnum;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author
 * @title: UnitTransformUtil
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2023/1/13 20:43
 */
@Slf4j
public class UnitTransformUtil {

    public static Map<String, Object> transformValues(String currentValue, String currentUnit, String minValue, String maxValue) {
        Map<String, Object> map = new HashMap<>();
        if (UnitEnum.MM.getKey().equalsIgnoreCase(currentUnit) || UnitEnum.MM.getName().equals(currentUnit)){
            BigDecimal divide = new BigDecimal(1000);
            if (StringUtil.isNotEmpty(currentValue) && !"--".equals(currentValue)){
                BigDecimal nowLevel = new BigDecimal(currentValue);
                map.put("nowValue", nowLevel.divide(divide,2,BigDecimal.ROUND_HALF_UP));

                BigDecimal nowVal = new BigDecimal(currentValue).divide(divide,2,BigDecimal.ROUND_HALF_UP);
                // status 中 0 表示过低；1 表示正常；2 表示过高
                if (StringUtil.isNotEmpty(minValue) && !"--".equals(minValue) && StringUtil.isNotEmpty(maxValue)
                        && !"--".equals(maxValue) && !"null".equalsIgnoreCase(minValue)&& !"--".equals(maxValue) && !"null".equalsIgnoreCase(maxValue)) {
                    if (nowVal.compareTo(new BigDecimal(minValue)) < 0) {
                        map.put("status", "0");
                        map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                    } else if (nowVal.compareTo(new BigDecimal(maxValue)) > 0) {  // 当前值大于最大值
                        map.put("status", "2");
                        map.put("abs", 100);
                    } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 0) {
                        map.put("status", "1");
                        map.put("abs", 100);
                    } else {
                        map.put("status", "1");
                        map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                    }
                } else {
                    map.put("status", "--");
                    map.put("abs", "--");
                }
            } else {
                map.put("nowValue", "--");
                map.put("status", "--");
                map.put("abs", "--");
            }

        } else if (UnitEnum.CM.getKey().equalsIgnoreCase(currentUnit) || UnitEnum.CM.getName().equals(currentUnit)){
            BigDecimal divide = new BigDecimal(100);
            if (StringUtil.isNotEmpty(currentValue) && !"--".equals(currentValue)){
                BigDecimal nowLevel = new BigDecimal(currentValue);
                map.put("nowValue", nowLevel.divide(divide,2,BigDecimal.ROUND_HALF_UP));

                BigDecimal nowVal = new BigDecimal(currentValue).divide(divide,2,BigDecimal.ROUND_HALF_UP);
                // status 中 0 表示过低；1 表示正常；2 表示过高
                if (StringUtil.isNotEmpty(minValue) && !"--".equals(minValue) && StringUtil.isNotEmpty(maxValue)
                        && !"--".equals(maxValue) && !"null".equalsIgnoreCase(minValue)&& !"--".equals(maxValue) && !"null".equalsIgnoreCase(maxValue)) {
                    if (nowVal.compareTo(new BigDecimal(minValue)) < 0) {
                        map.put("status", "0");
                        map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                    } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 1) {
                        map.put("status", "2");
                        map.put("abs", 100);
                    } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 0) {
                        map.put("status", "1");
                        map.put("abs", 100);
                    } else {
                        map.put("status", "1");
                        map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                    }
                } else {
                    map.put("status", "--");
                    map.put("abs", "--");
                }
            } else {
                map.put("nowValue", "--");
                map.put("status", "--");
                map.put("abs", "--");
            }

        } else if (UnitEnum.DM.getKey().equalsIgnoreCase(currentUnit) || UnitEnum.DM.getName().equals(currentUnit)) {
            BigDecimal divide = new BigDecimal(10);
            if (StringUtil.isNotEmpty(currentValue) && !"--".equals(currentValue)){
                BigDecimal nowLevel = new BigDecimal(currentValue);
                map.put("nowValue",nowLevel.divide(divide,2,BigDecimal.ROUND_HALF_UP));

                BigDecimal nowVal = new BigDecimal(currentValue).divide(divide,2,BigDecimal.ROUND_HALF_UP);
                // status 中 0 表示过低；1 表示正常；2 表示过高
                if (StringUtil.isNotEmpty(minValue) && !"--".equals(minValue) && StringUtil.isNotEmpty(maxValue)
                        && !"--".equals(maxValue) && !"null".equalsIgnoreCase(minValue)&& !"--".equals(maxValue) && !"null".equalsIgnoreCase(maxValue)) {
                    if (nowVal.compareTo(new BigDecimal(minValue)) < 0) {
                        map.put("status", "0");
                        map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                    } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 1) {
                        map.put("status", "2");
                        map.put("abs", 100);
                    } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 0) {
                        map.put("status", "1");
                        map.put("abs", 100);
                    } else {
                        map.put("status", "1");
                        map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                    }
                } else {
                    map.put("status", "--");
                    map.put("abs", "--");
                }
            } else {
                map.put("nowValue", "--");
                map.put("status", "--");
                map.put("abs", "--");
            }
        } else {
            BigDecimal nowVal = new BigDecimal(0);
            if (StringUtil.isNotEmpty(currentValue) && !"--".equals(currentValue)) {
                nowVal = new BigDecimal(currentValue);
                map.put("nowValue", nowVal.setScale(2, BigDecimal.ROUND_HALF_UP));
            } else {
                map.put("nowValue", "--");
            }
            // status 中 0 表示过低；1 表示正常；2 表示过高
            if (StringUtil.isNotEmpty(currentValue) && !"--".equals(currentValue)
                    && StringUtil.isNotEmpty(minValue) && !"--".equals(minValue)
                    && StringUtil.isNotEmpty(maxValue) && !"--".equals(maxValue) && StringUtil.isNotEmpty(currentUnit)
                    && !"null".equalsIgnoreCase(minValue)&& !"--".equals(maxValue) && !"null".equalsIgnoreCase(maxValue)) {
                if (nowVal.compareTo(new BigDecimal(minValue)) < 0) {
                    map.put("status", "0");
                    map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 1) {
                    map.put("status", "2");
                    map.put("abs", 100);
                } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 0) {
                    map.put("status", "1");
                    map.put("abs", 100);
                } else {
                    map.put("status", "1");
                    map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                }
            } else {
                map.put("status", "--");
                map.put("abs", "--");
            }
        }
        map.put("unit", "M");
        return map;
    }
    public static Map<String, Object> transformValuesLFM(String currentValue, String currentUnit, String minValue, String maxValue) {
        Map<String, Object> map = new HashMap<>();
        if (UnitEnum.LFM.getKey().equalsIgnoreCase(currentUnit) || UnitEnum.LFM.getName().equals(currentUnit)) {
            BigDecimal nowVal = new BigDecimal(0);
            if (StringUtil.isNotEmpty(currentValue) && !"--".equals(currentValue)) {
                nowVal = new BigDecimal(currentValue);
                map.put("nowValue", nowVal.setScale(2, BigDecimal.ROUND_HALF_UP));
            } else {
                map.put("nowValue", "--");
            }
            // status 中 0 表示过低；1 表示正常；2 表示过高
            if (StringUtil.isNotEmpty(minValue) && !"--".equals(minValue) && StringUtil.isNotEmpty(maxValue)
                    && !"--".equals(maxValue) && !"null".equalsIgnoreCase(minValue) && !"null".equalsIgnoreCase(maxValue)) {
                if (nowVal.compareTo(new BigDecimal(minValue)) < 0) {
                    map.put("status", "0");
                    map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                } else if (nowVal.compareTo(new BigDecimal(maxValue)) > 0) {  // 当前值大于最大值
                    map.put("status", "2");
                    map.put("abs", 100);
                } else if (nowVal.compareTo(new BigDecimal(maxValue)) == 0) {
                    map.put("status", "1");
                    map.put("abs", 100);
                } else {
                    map.put("status", "1");
                    map.put("abs", nowVal.divide(new BigDecimal(maxValue),2,BigDecimal.ROUND_HALF_UP).movePointRight(2));
                }
            } else {
                map.put("status", "--");
                map.put("abs", "--");
            }
        }
        map.put("unit", "m³");
        return map;
    }
}
