package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 项目出入场二维码
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_qrcode")
@ApiModel(value = "ProjectQrcode对象", description = "项目出入场二维码")
public class ProjectQrcode extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "工程id")
    private Long projectId;
    @ApiModelProperty(value = "二维码类型 0 入场 1 离场 2上岗 3离岗")
    private String qrcode;
    @ApiModelProperty(value = "二维码类型")
    private Integer type;
    @ApiModelProperty(value = "频率 分钟计算")
    private String frequency;
}
