package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.StatisticsDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.vo.WorkActivityVo;

import java.util.List;
import java.util.Map;

public interface IStatisticsService {

	/**
	 * 今日监控
	 * 
	 * @return
	 */
	Map<String, Object> todayRegulate(StatisticsDto statisticsDto);

	/**
	 * 今日监管-在建项目
	 *
	 * @return
	 */
	Map<String, Object> todayRegulateProject(StatisticsDto statisticsDto);

	/**
	 * 今日监管-风险作业
	 *
	 * @return
	 */
	Map<String, Object> todayRegulateRisk(StatisticsDto statisticsDto);

	/**
	 * 今日监管-今日违章
	 *
	 * @return
	 */
	Map<String, Object> todayRegulateBad(StatisticsDto statisticsDto);

	/**
	 * 今日监管-技术交底
	 *
	 * @return
	 */
	Map<String, Object> todayRegulateTech(StatisticsDto statisticsDto);

	/**
	 * 今日监管-入场人员
	 *
	 * @return
	 */
	Map<String, Object> todayRegulatePersonIn(StatisticsDto statisticsDto);

	/**
	 * 今日监管-未交底人员
	 *
	 * @return
	 */
	Map<String, Object> todayRegulatePersonNoTech(StatisticsDto statisticsDto);
	
	/**
	 * 今日监管-作业票
	 *
	 * @return
	 */
	Map<String, Object> todayRegulateTicket(StatisticsDto statisticsDto);

	/**
	 * 统计- 综合统计
	 *
	 * @return
	 */
	Map<String, Object> comprehensiveStatistical(StatisticsDto statisticsDto);

	/**
	 * 统计-作业活动
	 *
	 * @return
	 */
	Map<String, Object> operationActivities(StatisticsDto statisticsDto);

	/**
	 * 统计-安全分析
	 *
	 * @return
	 */
	Map<String, Object> safetyAnalysis(StatisticsDto statisticsDto);

	/**
	 * 统计-知识分享
	 *
	 * @return
	 */
	Map<String, Object> knowledgeShare(StatisticsDto statisticsDto);

	/**
	 * 今日统计
	 *
	 * @return
	 */
	Map<String, Object> statisticsToday(StatisticsDto statisticsDto);

	/**
	 * 根据项目部门查询统计信息
	 *
	 * @param orgCode 部门代码
	 * @return
	 */
	Map<String, Integer> getProjectStatistics(StatisticsDto statisticsDto);
	
	/**
	 * 任务统计
	 * @param statisticsDto
	 * @return Object
	 */
    Object taskStatistics(StatisticsDto statisticsDto);

	/**
	 * 任务明细列表
	 * @param sequenceNbr 主键
	 * @param userId 用户id
	 * @return List
	 */
	List getTaskDetail(Long sequenceNbr, String userId);

	/**
	 * 查询知识库随机列表
	 * @param total 总数
	 * @return List
	 */
    List getKnowledgeRandomList(Integer total);

	/**
	 * 查询登录人待办任务状态
	 * @param person  当前操作人
	 * @param companyId 公司id
	 * @param projectId 项目id
	 * @return Object
	 */
	Object getTaskDealStatus(Person person, Long companyId, Long projectId);

	/**
	 * 入场人数统计
	 * @param orgCode
	 * @return
	 */
	Integer sumPersonIn(String orgCode, Long projectId);

	/**
	 * websocket 推送数据
	 * @param orgCode
	 * @param businessType  all 推送所有
	 */
    void initWs(String orgCode, String businessType);

	/**
	 * websocket 获取推送数据
	 * @param orgCodeParam
	 * @param businessType  all 推送所有
	 */
	String queryStatisticsData(String orgCodeParam, String businessType);

	/**
	 * 获取某个项目的推送数据
	 * @param orgCodeParam
	 * @param projectId
	 * @return
	 */
	String queryStatisticsDataByProjectId(String orgCodeParam, Long projectId);

	/**
	 * 作业活动分页列表
	 * @param workActivityVo
	 * @param pageable
	 * @return
	 */
    IPage<WorkActivityVo> workActivityPageInfo(WorkActivityVo workActivityVo, CommonPageableDto pageable);
}
