package com.yeejoin.amos.supervision.core.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CheckReportDto implements Serializable {

    @ApiModelProperty(value = "检查报告id")
    Long id;

    @ApiModelProperty(value = "报告名称")
    String name;

    @ApiModelProperty(value = "所属计划名称")
    String planName;

    @ApiModelProperty(value = "计划检查类型")
    String planCheckType;

    @ApiModelProperty(value = "检查级别")
    String planCheckLevel;

    @ApiModelProperty(value = "计划开始时间")
    Date startPlanTaskDate;

    @ApiModelProperty(value = "计划结束时间")
    Date endPlanTaskDate;

    @ApiModelProperty(value = "执行人")
    String checkUser;

    @ApiModelProperty(value = "计划任务id")
    Long planTaskId;

    @ApiModelProperty(value = "实际开始时间")
    Date startCheckDate;

    @ApiModelProperty(value = "实际结束时间")
    Date endCheckDate;

    @ApiModelProperty(value = "检查单位数量")
    Integer companyCount;

    @ApiModelProperty(value = "存在问题单位数量")
    Integer problemCompanyCount;

    @ApiModelProperty(value = "是否有重大隐患（1有，0无）")
    Boolean hasMajorDanger;

    @ApiModelProperty(value = "是否有重大隐患（1有，0无）")
    String hasMajorDangerStr;
    
    @ApiModelProperty(value = "存在安全隐患数量")
    Integer dangerCount;

    @ApiModelProperty(value = "现场已整改隐患数量")
    Integer onsiteReformCount;

    @ApiModelProperty(value = "复查隐患数量")
    Integer reviewDangerCount;

    @ApiModelProperty(value = "复查已整改隐患数量")
    Integer reviewReformedCount;

    @ApiModelProperty(value = "复查整改中隐患数量")
    Integer reviewReformingCount;

    @ApiModelProperty(value = "剩余隐患数量")
    Integer remainingDangerCount;

    @ApiModelProperty(value = "机构代码")
    String orgCode;

    @ApiModelProperty(value = "创建时间")
    Date createDate;

    @ApiModelProperty(value = "检查单位列表")
    List<CheckReportCompanyDto> checkCompanyList;

    @ApiModelProperty(value = "本次检查隐患列表")
    List<CheckReportDangerDto> checkDangerList;

    @ApiModelProperty(value = "本次隐患复查列表")
    List<CheckReportDangerDto> reviewDangerList;

    @ApiModelProperty(value = "本次隐患id")
    String dangerIds;

    @ApiModelProperty(value = "本次复查隐患id")
    String reviewDangerIds;

    @ApiModelProperty(value = "计划执行频次")
    String planCheckFrequencyType;

    @ApiModelProperty(value = "报告时期")
    String reportDate;

    @ApiModelProperty(value = "当前日期")
    String nowDate;
}
