package com.yeejoin.equipmanage.fegin;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.equipmanage.common.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;


/**
 * @author DELL
 */
@FeignClient(name = "${jcs.fegin.name}",path = "jcs", configuration = {FeignConfiguration.class})
public interface JcsFeign {

    @RequestMapping(value = "/water-resource/select_list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<WaterResourceDto>> selectList(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "sequenceNbr", required = false) Long sequenceNbr,
            @RequestParam(value = "belongFightingSystemId", required = false) Long belongFightingSystemId,
            @RequestParam(value = "belongBuildingId", required = false) Long belongBuildingId,
            @RequestParam(value = "belongBuilding", required = false) String belongBuilding,
            @RequestParam(value = "resourceType", required = false) String resourceType);

    @RequestMapping(value = "/water-resource/page", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<Page<WaterResourceDto>> queryForPage(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "pageNum") int pageNum,
            @RequestParam(value = "pageSize") int pageSize,
            @RequestParam(value = "name") String name,
            @RequestParam(value = "belongBuildingId") List<Long> belongBuildingId,
            @RequestParam(value = "belongFightingSystemId") Long belongFightingSystemId,
            @RequestParam(value = "sequenceNbr") Long sequenceNbr,
            @RequestParam(value = "classifyId") String classifyId,
            @RequestParam(value = "ids") List<String> ids
    );

    @RequestMapping(value = "/equip/fireSystem_waterResource/list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<MenuFromDto>> getFireSystemWaterResourceList(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token
    );

    @RequestMapping(value = "/water-resource/resource_type_list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<WaterResourceTypeDto>> selectResourceTypeList(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token
    );

    @RequestMapping(value = "/common/maintenance-company/companyList", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<Map<String, Object>>> selectCompanyList(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token
    );

    @RequestMapping(value = "/org-usr/{userId}/userInfo", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<UserDto>> getUserInfo(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @PathVariable(value = "userId") String userId);

    @RequestMapping(value = "/excel/exportForEquipment", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<String[]> getEquipmentInfo(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "type", required = false) String type,
            @RequestParam(value = "method", required = false) String method);


    @RequestMapping(value = "/firefighters/getUserCar/{carId}/{teamId}", method = RequestMethod.GET, consumes = "application/json")
    void getUserCar(
            @PathVariable(value = "carId") Long carId,
            @PathVariable(value = "teamId") String teamId);





    /**
     * <pre>
     * 根据值班区域ID查询当前值班人
     * </pre>
     *
     * @param dutyAreaId
     * @return
     */
    @RequestMapping(value = "/common/duty-person/findByDutyAreaId/{dutyAreaId}", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<Object> findByDutyAreaId(@PathVariable(value = "dutyAreaId") Long dutyAreaId);

    /**
     * 获取机场单位
     */
    @RequestMapping(value = "/org-usr/getUnit/{id}", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<JSONObject> getUnitById(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @PathVariable(value = "id") String id);

    /**
     * 获取机场人员
     *
     * @return
     */
    @RequestMapping(value = "/org-person/getPersonByUserId/{userId}", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<JSONObject> getPersonByUserId(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @PathVariable(value = "userId") String userId);

    /**
     * 查询有权限的公司部门部门树
     *
     * @param authKey 权限key
     * @param orgType 树类型null,公司部门树，COMPANY: 公司树 DEPARTMENT部门树
     * @return ResponseModel<OrgUsrDto>
     */
    @GetMapping(value = "/org-usr/{authKey}/treeWithAuth")
    FeignClientResult<List<OrgMenuDto>> getCompanyDeptTreeWithAuth(@PathVariable(value = "authKey") String authKey, @RequestParam(value = "orgType", required = false) String orgType);

    /**
     * 查询有权限的公司部门列表
     *
     * @param authKey          权限key
     * @param orgTypes(多个逗号分隔) 为空默认查询公司和部门，COMPANY: 公司树 DEPARTMENT部门树
     * @return ResponseModel<OrgUsrDto>
     */
    @GetMapping(value = "/org-usr/{authKey}/listWithAuth")
    FeignClientResult<List<OrgUsrDto>> getCompanyDeptListWithAuth(
            @RequestHeader(value = "Appkey") String appKey,
            @RequestHeader(value = "Product") String product,
            @RequestHeader(value = "Token") String token,
            @PathVariable(value = "authKey") String authKey,
            @RequestParam(value = "orgTypes", required = false) String orgTypes,
            @RequestParam(value = "type", required = false) String type
    );

    @GetMapping(value = "/org-usr/{authKey}/listWithAuthToPartol")
    FeignClientResult<List<OrgUsrDto>> getCompanyDeptListWithAuthToPartol(@PathVariable(value = "authKey") String authKey, @RequestParam(value = "orgTypes", required = false) String orgTypes);


    /**
     * 查询指定部门的上级单位
     *
     * @return
     */
    @RequestMapping(value = "/org-usr/company/bizOrgCode/list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<OrgUsrDto> getCompanyByBizOrgCodeList(
            @RequestParam(value = "bizOrgCode", required = false) String bizOrgCode);

    /**
     * 根据amosId查询人员
     *
     * @return
     */
    @RequestMapping(value = "/org-usr/find/getByAmosId", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<OrgUsrDto>> getByAmosId(
            @RequestParam(value = "amosIds", required = false) List<String> amosIds);

    /**
     * 根据amosId查询人员
     *
     * @return
     */
    @RequestMapping(value = "/equip/getMaintenanceId", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<Long> getMaintenanceId(
            @RequestParam(value = "userId") String userId);

    /**
     * 查询有权限的公司部门列表
     *
     * @param authKey          权限key
     * @param orgTypes(多个逗号分隔) 为空默认查询公司和部门，COMPANY: 公司树 DEPARTMENT部门树
     * @return ResponseModel<OrgUsrDto>
     */
    @GetMapping(value = "/org-usr/listCompanyTree")
    FeignClientResult<List<OrgUsrDto>> getlistCompanyTree( @RequestParam(required = false,value = "orgType") String orgType);

    /**
     * 查询用户单位信息
     * @param userId 用户id
     * @return ResponseModel<ReginParams.PersonIdentity>
     */
    @GetMapping(value = "/org-person/getUser/{id}")
    FeignClientResult selectById(@PathVariable(value = "id") String id);


    @GetMapping(value = "/org-usr/getCompany")
    FeignClientResult getCompany( @RequestParam(value = "bizOrgCode") String bizOrgCode);

    @GetMapping(value = "/data-dictionary/dataDictionaryIdFillMenu")
    FeignClientResult<List<DataDictionary>> dataDictionaryIdFillMenu(@RequestParam(value = "type") String type);
}
